﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pcv/pcv.h>
#include <nn/tc/tc_Types.h>
#include <nn/tc/impl/tc_PowerModeTypes.h>

namespace nn { namespace tc { namespace impl { namespace detail {

class SettingHandler {

public:
    SettingHandler()
    : m_NumberOfThresholds(0)
    , m_CurrentThresholdIndex(0)
    , m_ForceUpdateTemperature(false)
    , m_PowerMode(PowerMode_FullAwake)
    , m_LastDvfsTemperature(0)
    {
    }
    virtual void Initialize() NN_NOEXCEPT;
    virtual void Finalize() NN_NOEXCEPT;
    virtual void SetTemperature(TemperatureMilliC temperature) NN_NOEXCEPT;
    virtual void SetPowerMode(PowerMode powerMode) NN_NOEXCEPT;
    TemperatureMilliC GetLastDvfsTemperature() NN_NOEXCEPT;

private:
    nn::pcv::TemperatureThreshold m_TemperatureThresholds[nn::pcv::MaxNumTemperatureThresholds];
    int m_NumberOfThresholds;
    int m_CurrentThresholdIndex;
    bool m_ForceUpdateTemperature;
    PowerMode m_PowerMode;
    TemperatureMilliC m_LastDvfsTemperature;

private:
    int CheckThreshold(TemperatureMilliC temperature) NN_NOEXCEPT;
};

}}}} // namespace nn::tc::impl::detail
