﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/detail/ssl_Common.h>
#include "ssl_Util.h"

#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace ssl { namespace detail {

nn::Result Util::ConvertResultFromInternalToExternal(nn::Result result)
{
    if(result.IsSuccess() || ResultSslService::Includes(result))
    {
        return result; // no error or result is public
    }

    if(ResultInternal::Includes(result) || ResultInternalNss::Includes(result))
    {
        // Getting internal result here means there's somthing missing in the code where it
        // requires result value translation from internal to public one
        NN_DETAIL_SSL_DBG_PRINT("[Util::ConvertResultFromInternalToExternal]ERROR: Internal logic (Desc:%d)\n",
            result.GetDescription());
        return ResultInternalLogicError();
    }

    // Reaching here means there's a result that is "Internal" and does not belong to nn::ssl name space
    NN_DETAIL_SSL_DBG_PRINT("[Util::ConvertResultFromInternalToExternal]ERROR: Unhandled result (Module:%d Desc:%d)\n",
        result.GetModule(),
        result.GetDescription());
    return ResultErrorLower();
}

bool Util::IsInitializeForTestEnabled()
{
    static bool s_NeedToCheckValue = true;
    static size_t s_IsInitForTestEnabled = 0;

    if(s_NeedToCheckValue)
    {
        s_IsInitForTestEnabled = settings::fwdbg::GetSettingsItemValue(&s_IsInitForTestEnabled, sizeof(s_IsInitForTestEnabled), "ssl.test", "initialize_for_test");
        s_NeedToCheckValue = false;
    }

    return (s_IsInitForTestEnabled != 0);
}

}}} // namespace nn { namespace ssl { namespace detail {
