﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/os.h>
#include <nn/nn_Result.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace ssl { namespace detail {

class SslSfObservable;

class SslSfObserver
{
public:
    virtual ~SslSfObserver() NN_NOEXCEPT;
    virtual void OnDestroy(SslSfObservable *object) NN_NOEXCEPT = 0;
};

// Because we are using an intrusive list, each list the object is contained in needs its own node.
// We know that SslSfObserver could be contained in more than one list.
// This is why we have to make a wrapper class, creating a new node for each list.
class SslSfObserverListElement
{
public:
    explicit SslSfObserverListElement(SslSfObserver& observer) NN_NOEXCEPT;
    bool operator==(const SslSfObserverListElement& rhs) const NN_NOEXCEPT;

    SslSfObserver& Get() NN_NOEXCEPT;


    nn::util::IntrusiveListNode listNode;

private:
    SslSfObserver& m_observer;
};

typedef nn::util::IntrusiveList<
    SslSfObserverListElement,
    nn::util::IntrusiveListMemberNodeTraits<SslSfObserverListElement, &SslSfObserverListElement::listNode> >
        SfObserverListType;

class SslSfObservable
{
private:
    nn::os::Mutex                 m_Lock;
    SfObserverListType            m_Observers;

protected:
    void NotifyObservers() NN_NOEXCEPT;

public:
    SslSfObservable() NN_NOEXCEPT;
    ~SslSfObservable() NN_NOEXCEPT;

    nn::Result AddObserver(SslSfObserver *observer) NN_NOEXCEPT;
    nn::Result RemoveObserver(SslSfObserver *observer) NN_NOEXCEPT;

    bool operator==(const SslSfObservable& rhs) const NN_NOEXCEPT;

    nn::util::IntrusiveListNode listNode;
};

} } }
