﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/detail/ssl_Common.h>
#include "ssl_NssCommon.h"

namespace nn { namespace ssl { namespace detail {

class SslSessionManager
{
public:
    enum SessionCacheMode
    {
        SessionCacheMode_None          = 0x00,
        SessionCacheMode_SessionId     = 0x01,
        SessionCacheMode_SessionTicket = 0x02,
    };

    nn::Result Initialize();
    nn::Result Finalize();

    static nn::Result SetSessionCacheMode(
        PRFileDesc* pInSocket,
        SessionCacheMode mode);
    static nn::Result GetSessionCacheMode(
        PRFileDesc* pInSocket,
        SessionCacheMode* pOutMode);
    static nn::Result DeleteSessionCache(PRFileDesc* pInDescriptor);
    static nn::Result GetSessionId(
        char* pOutSessionIdBuff,
        uint64_t* pOutsessionIdSize,
        PRFileDesc* pInDescriptor,
        uint64_t sessionIdBuffSize);
};

}}} // namespace nn { namespace ssl { namespace detail {
