﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ssl/ssl_Types.h>

namespace nn { namespace ssl { namespace detail {

class SslApiBase
{
private:
    uint64_t m_ReferenceCount;

public:
    SslApiBase();
    ~SslApiBase();

    virtual nn::Result Initialize() NN_NOEXCEPT;
    virtual nn::Result Finalize() NN_NOEXCEPT;

    static nn::Result GetSslResultFromValue(
        nn::Result* pOutResult,
        const char* pInValue,
        uint32_t inValueSize) NN_NOEXCEPT;
};

}}}
