﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/srepo/detail/service/srepo_SrepoService.generic.h>
#include <nn/srepo/srepo_Result.h>
#include <nn/srepo/srepo_Types.h>

namespace nn { namespace srepo { namespace detail { namespace service {

SrepoServiceForGeneric::SrepoServiceForGeneric() NN_NOEXCEPT
{
}

SrepoServiceForGeneric::~SrepoServiceForGeneric() NN_NOEXCEPT
{
}

nn::Result SrepoServiceForGeneric::SaveReport(const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT
{
    NN_UNUSED(eventId);
    NN_UNUSED(appId);
    NN_UNUSED(data);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::SaveReportWithUser(const nn::account::Uid& uid,
    const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(eventId);
    NN_UNUSED(appId);
    NN_UNUSED(data);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::SaveReportForAntiPiracy(const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT
{
    NN_UNUSED(eventId);
    NN_UNUSED(appId);
    NN_UNUSED(data);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::SaveReportWithUserForAntiPiracy(const nn::account::Uid& uid,
    const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(eventId);
    NN_UNUSED(appId);
    NN_UNUSED(data);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::PopReport(nn::sf::Out<std::int32_t> outCategory, nn::sf::Out<nn::account::Uid> outUid, const nn::sf::OutArray<char>& outEventId, nn::sf::Out<nn::ApplicationId> outAppId, nn::sf::Out<std::int64_t> outDataSize, const nn::sf::OutBuffer& outData) NN_NOEXCEPT
{
    NN_UNUSED(outCategory);
    NN_UNUSED(outUid);
    NN_UNUSED(outEventId);
    NN_UNUSED(outAppId);
    NN_UNUSED(outDataSize);
    NN_UNUSED(outData);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::GetPushEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
{
    NN_UNUSED(outHandle);

    NN_RESULT_SUCCESS;
}
nn::Result SrepoServiceForGeneric::NotifyUserList(const nn::sf::InArray<nn::account::Uid>& userList) NN_NOEXCEPT
{
    NN_UNUSED(userList);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyUserDeleted(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyUserRegistered(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyUserClosed(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyUserOpened(const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_UNUSED(uid);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyCompletedNetworkRequestChanged(int8_t type) NN_NOEXCEPT
{
    NN_UNUSED(type);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyFriendPresenceChanged(const nn::account::Uid& uid, int8_t state) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(state);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyNotificationConnectivityChanged(int8_t state) NN_NOEXCEPT
{
    NN_UNUSED(state);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyDeviceOperationModeChanged(int8_t mode) NN_NOEXCEPT
{
    NN_UNUSED(mode);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifySystemPowerStateChanged(int8_t state) NN_NOEXCEPT
{
    NN_UNUSED(state);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyForegroundProgramChanged(const nn::ncm::ProgramId& id) NN_NOEXCEPT
{
    NN_UNUSED(id);

    NN_RESULT_SUCCESS;
}

nn::Result SrepoServiceForGeneric::NotifyControllerCountChanged(int8_t total, int8_t rail) NN_NOEXCEPT
{
    NN_UNUSED(total);
    NN_UNUSED(rail);

    NN_RESULT_SUCCESS;
}

}}}}
