﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/srepo/detail/service/core/srepo_SomeValue.h>
#include <nn/util/util_FormatString.h>

namespace nn { namespace srepo { namespace detail { namespace service { namespace core {

template <>
const SomeValueTag SomeValue<int32_t>::Tag = SomeValueTag::Int32;
template <>
const SomeValueTag SomeValue<bool>::Tag = SomeValueTag::Bool;
template <>
const SomeValueTag SomeValue<nn::ncm::ProgramId>::Tag = SomeValueTag::ProgramId;
template <>
const SomeValueTag SomeValue<String16>::Tag = SomeValueTag::String16;
template <>
const SomeValueTag SomeValue<AccountStatus>::Tag = SomeValueTag::AccountStatus;
template <>
const SomeValueTag SomeValue<ControllerStatus>::Tag = SomeValueTag::ControllerStatus;
template <>
const SomeValueTag SomeValue<nn::srepo::DeviceOperationMode>::Tag = SomeValueTag::DeviceOperationMode;
template <>
const SomeValueTag SomeValue<nn::srepo::SystemPowerState>::Tag = SomeValueTag::SystemPowerState;
template <>
const SomeValueTag SomeValue<nn::srepo::FriendPresence>::Tag = SomeValueTag::FriendPresence;
template <>
const SomeValueTag SomeValue<nn::srepo::CompletedNetworkRequestType>::Tag = SomeValueTag::CompletedNetworkRequestType;

SomeValueString::SomeValueString(const SomeValueBase* pSrc) NN_NOEXCEPT
{
    Set(pSrc);
}

const char* SomeValueString::Set(const SomeValueBase* pSrc) NN_NOEXCEPT
{
    m_pString = ToString(pSrc, m_Buffer, sizeof(m_Buffer));
    NN_SDK_ASSERT_NOT_NULL(m_pString);
    return m_pString;
}

const char* SomeValueString::ToString(const SomeValueBase* pSrc, char* pBuffer, size_t size) const NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pSrc);

    // ハードコードした文字列をなるべく扱う.
    // それが無理な場合(formatが必要とか)は pBuffer に文字列を作る.

    switch(pSrc->GetTag())
    {
        case SomeValue<bool>::Tag:
            {
                auto p = static_cast<const SomeValue<bool>*>(pSrc);
                return p->GetRef() ? "1" : "0";
            }
        case SomeValue<int32_t>::Tag:
            {
                auto p = static_cast<const SomeValue<int32_t>*>(pSrc);
                NN_DETAIL_SREPO_SN_PRINTF(pBuffer, size, "%ld", p->GetRef());
                return pBuffer;
            }
        case SomeValue<nn::ncm::ProgramId>::Tag:
            {
                auto p = static_cast<const SomeValue<nn::ncm::ProgramId>*>(pSrc);
                NN_DETAIL_SREPO_SN_PRINTF(pBuffer, size, "0x%016llx", p->GetRef());
                return pBuffer;
            }
        case SomeValue<String16>::Tag:
            {
                auto p = static_cast<const SomeValue<String16>*>(pSrc);
                NN_DETAIL_SREPO_STRLCPY(pBuffer, p->GetRef().value, static_cast<int>(size));
                return pBuffer;
            }
        case SomeValue<AccountStatus>::Tag:
            {
                auto p = static_cast<const SomeValue<AccountStatus>*>(pSrc);
                return p->GetRef().isOpened ? "open" : "close";
            }
        case SomeValue<ControllerStatus>::Tag:
            {
                auto p = static_cast<const SomeValue<ControllerStatus>*>(pSrc);
                NN_DETAIL_SREPO_SN_PRINTF(pBuffer, size, "%d,%d", p->GetRef().totalNum, p->GetRef().railNum);
                return pBuffer;
            }
        case SomeValue<nn::srepo::DeviceOperationMode>::Tag:
            {
                static const char* Names[] =
                {
                    "Handheld",
                    "Console",
                    "Unknown",
                };
                auto p = static_cast<const SomeValue<nn::srepo::DeviceOperationMode>*>(pSrc);
                return Names[static_cast<int>(p->GetRef())];
            }
        case SomeValue<nn::srepo::SystemPowerState>::Tag:
            {
                static const char* Names[] =
                {
                    "FullAwake",
                    "MinimumAwake",
                    "MinimumAwakeForLowBatterySign",
                    "MinimumAwakeForBackgroundTask",
                    "SleepReady",
                    "ShutdownReady",
                };
                auto p = static_cast<const SomeValue<nn::srepo::SystemPowerState>*>(pSrc);
                return Names[static_cast<int>(p->GetRef())];
            }
        case SomeValue<nn::srepo::FriendPresence>::Tag:
            {
                static const char* Names[] =
                {
                    "Offline",
                    "Online",
                    "OnlinePlay",
                };
                auto p = static_cast<const SomeValue<nn::srepo::FriendPresence>*>(pSrc);
                return Names[static_cast<int>(p->GetRef())];
            }
        case SomeValue<nn::srepo::CompletedNetworkRequestType>::Tag:
            {
                static const char* Names[] =
                {
                    "None",
                    "WideAreaNetwork",
                    "LocalAreaNetwork",
                    "LocalDirectNetwork",
                    "NeighborDetection",
                };
                auto p = static_cast<const SomeValue<nn::srepo::CompletedNetworkRequestType>*>(pSrc);
                return Names[static_cast<int>(p->GetRef())];
            }
        default: NN_UNEXPECTED_DEFAULT;
    }
} // NOLINT(impl/function_size)

}}}}}
