﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/srepo/detail/service/core/srepo_DurationManager.h>
#include <nn/nn_SdkLog.h>

namespace nn { namespace srepo { namespace detail { namespace service { namespace core {

// SystemDurationKindごとの個別初期ステート設定
void SystemStateChangeManager::InitializeImpl(const nn::TimeSpan& current) NN_NOEXCEPT
{
    NN_UNUSED(current);

    // 個別の初期ステート設定

    auto MakeStateChangePoint = [&current](SomeValueBase* pValue)
    {
        StateChangePoint ret = {pValue, current};
        return ret;
    };

    GetStateChangePointRef(SystemDurationKind::CompletedNetworkRequestType) = MakeStateChangePoint(&m_CompletedNetworkRequestType );
    GetStateChangePointRef(SystemDurationKind::ConnectionOfNotification) = MakeStateChangePoint(&m_ConnectionOfNotification);
    GetStateChangePointRef(SystemDurationKind::ForegroundProgramId) = MakeStateChangePoint(&m_ForegroundProgramId);
    GetStateChangePointRef(SystemDurationKind::DeviceOperationMode) = MakeStateChangePoint(&m_DeviceOperationMode);
    GetStateChangePointRef(SystemDurationKind::SystemPowerState) = MakeStateChangePoint(&m_PowerState);
    GetStateChangePointRef(SystemDurationKind::ControllerStatus) = MakeStateChangePoint(&m_ControllerStatus);
}

// UserDurationKindごとの個別初期ステート設定
void OneUserStateChangeManager::InitializeImpl(const nn::TimeSpan& current) NN_NOEXCEPT
{
    NN_UNUSED(current);

    // 個別の初期ステート設定

    auto MakeStateChangePoint = [&current](SomeValueBase* pValue)
    {
        StateChangePoint ret = {pValue, current};
        return ret;
    };

    GetStateChangePointRef(UserDurationKind::AccountStatus) = MakeStateChangePoint(&m_AccountStatus);
    GetStateChangePointRef(UserDurationKind::FriendPresence) = MakeStateChangePoint(&m_FriendPresence);
}

void MultiUserDurationManager::Register(const nn::account::Uid& uid, const nn::TimeSpan& current) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(!IsUserRegisterd(uid), "A uid is registered already. (uid:%016llx-%016llx)", uid._data[0], uid._data[1]);

    for(auto& data : m_UserDataArray)
    {
        if(!static_cast<bool>(data))
        {
            data.emplace(uid, current);
            return;
        }
    }

    NN_ABORT("[srepo::MultiUserDurationManager] User count is max.");
}

void MultiUserDurationManager::Unregister(const nn::account::Uid& uid) NN_NOEXCEPT
{
    for(auto& data : m_UserDataArray)
    {
        if(static_cast<bool>(data) && (*data).GetUid() == uid)
        {
            data = nn::util::nullopt;
            return;
        }
    }

    NN_ABORT("[srepo::MultiUserDurationManager] User not found. (uid:%016llx-%016llx)", uid._data[0], uid._data[1]);
}

int MultiUserDurationManager::GetRegisteredUserList(nn::account::Uid outUids[UserRegistrationCountMax]) const NN_NOEXCEPT
{
    int outCount = 0;
    for(auto& data : m_UserDataArray)
    {
        if(static_cast<bool>(data))
        {
            outUids[outCount++] = (*data).GetUid();
        }
    }

    return outCount;
}

bool MultiUserDurationManager::IsUserRegisterd(const nn::account::Uid& uid) const NN_NOEXCEPT
{
    for(auto& data : m_UserDataArray)
    {
        if(static_cast<bool>(data) && (*data).GetUid() == uid)
        {
            return true;
        }
    }
    return false;
}

const MultiUserDurationManager::UserData& MultiUserDurationManager::GetUserData(const nn::account::Uid& uid) const NN_NOEXCEPT
{
    for(auto& data : m_UserDataArray)
    {
        if(static_cast<bool>(data) && (*data).GetUid() == uid)
        {
            return *data;
        }
    }
    NN_ABORT("[srepo::MultiUserDurationManager] User not found. (uid:%016llx-%016llx)", uid._data[0], uid._data[1]);
}

MultiUserDurationManager::UserData& MultiUserDurationManager::GetUserData(const nn::account::Uid& uid) NN_NOEXCEPT
{
    return const_cast<MultiUserDurationManager::UserData&>(static_cast<const MultiUserDurationManager&>(*this).GetUserData(uid));
}

}}}}}
