﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include "spsm_Debug.h"

namespace nn { namespace spsm { namespace server {

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    const char* GetPowerStateNameString(nn::spsm::PowerState state) NN_NOEXCEPT
    {
        #define NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(name) case PowerState_##name: { return NN_MACRO_STRINGIZE(name); }

        switch (state)
        {
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(None)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(Initial)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(Error)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(FullAwake)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(MinimumAwake)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(MinimumAwakeForLowBatterySign)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(MinimumAwakeForBackgroundTask)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(SleepReady)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(ShutdownReady)
        } // NOLINT(style/switch_default)

        #undef NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING

        NN_SDK_ASSERT(false, "NEVER REACHED HERE\n");
        return "";
    }

    const char* GetPowerStateMessageNameString(nn::spsm::server::PowerStateMessage message) NN_NOEXCEPT
    {
        #define NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(name) case PowerStateMessage_##name: { return NN_MACRO_STRINGIZE(name); }

        switch (message)
        {
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(None)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(StartStateMachine)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(SleepRequested)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(ShutdownRequested)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(RebootRequested)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventPowerButtonStartedPressing)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventPowerButtonPressedBriefly)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventPowerButtonPressedFor3Sec)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventPowerButtonPressedFor7Sec)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventAutoPowerDownTimerExpired)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventCecSystemStandbyReceived)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventSleepRequiredByHighTemperature)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventSleepRequiredByLowBattery)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventShutdownRequiredByVeryLowBattery)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventBackgroundTaskDone)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventHomeButtonStartedPressing)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventHomeButtonPressedBriefly)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventHomeButtonPressedLong)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventInternalTimerExpired)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventPowerSupplyChanged)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventSdCardStateChanged)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventGameCardStateChanged)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(EventFullAwakeRequestedByController)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(PutErrorRequested)
            NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING(Count)
        } // NOLINT(style/switch_default)

        #undef NN_DETAIL_SPSM_RETURN_CASE_LABEL_STRING

        NN_SDK_ASSERT(false, "NEVER REACHED HERE\n");
        return "";
    }
#endif

}}}

