﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/spsm/detail/spsm_Log.h>
#include <nn/spsm/server/spsm_PowerStateMessageQueue.h>

#include "spsm_IEventHandler.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  DebugPowerStateMessageSender 監視用クラス
//  fwdbg の設定に従って、起動後の任意時間経過したところで指定されたメッセージを飛ばすテスト用機能
//
class DebugPowerStateMessageSender final : public IEventHandler
{
public:
    void Initialize(nn::spsm::server::PowerStateMessageQueue*) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_DebugPowerStateMessageSenderHolder);
    }
    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_DebugPowerStateMessageSenderHolder);
    }
    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder) NN_NOEXCEPT
    {
        if (holder == &m_DebugPowerStateMessageSenderHolder)
        {
            ProcessDebugPowerStateMessageSender();
            return true;
        }
        return false;
    }

private:
    void ProcessDebugPowerStateMessageSender() NN_NOEXCEPT;

    void NotifyDebugPowerStateMessageSender() NN_NOEXCEPT
    {
        // NN_DETAIL_SPSM_INFO_V1("sending emulated power state message\n");
        m_pPowerStateMessageQueue->Enqueue(AddTimeStamp(m_PowerStateMessageToEmulate));
    }

private:
    nn::spsm::server::PowerStateMessageQueue* m_pPowerStateMessageQueue;

    nn::spsm::server::PowerStateMessage       m_PowerStateMessageToEmulate{ nn::spsm::server::PowerStateMessage_None };
    os::TimerEventType      m_DebugPowerStateMessageSender;
    os::MultiWaitHolderType m_DebugPowerStateMessageSenderHolder;
};

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

