﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/cec/cec_Api.h>

#include "spsm_CecSystemStandby.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  初期化
//
void CecSystemStandby::Initialize(nn::spsm::server::PowerStateMessageQueue* pPowerStateMessageQueue) NN_NOEXCEPT
{
    m_pPowerStateMessageQueue = pPowerStateMessageQueue;
}

void CecSystemStandby::SetCecEvent(nn::os::SystemEventType* pCecEventType) NN_NOEXCEPT
{
    m_pCecSystemStandby = pCecEventType;
    os::InitializeMultiWaitHolder(&m_CecSystemStandbyHolder, m_pCecSystemStandby);

    m_CecSystemStandbyHolder.userData = reinterpret_cast<uintptr_t>(this);
}

//-----------------------------------------------------------------------------
//  デストラクタ
//
void CecSystemStandby::Finalize() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder(&m_CecSystemStandbyHolder);
}

//-----------------------------------------------------------------------------
//  CecSystemStandby のハンドラ関数（多重待ち解除時に呼ばれる）
//
void CecSystemStandby::ProcessCecSystemStandby() NN_NOEXCEPT
{
    if (!nn::os::TryWaitSystemEvent(m_pCecSystemStandby))
    {
        return;
    }

    nn::cec::BusEventType busEvent;
    auto result = nn::cec::GetBusEventType(&busEvent);
    if ( result.IsFailure() )
    {
        NN_DETAIL_SPSM_WARN("Could not get bus event type: 0x%08x\n", result.GetInnerValueForDebug());
        return;
    }
    NN_DETAIL_SPSM_TRACE("spsm: cec::GetBusEventType %d\n", busEvent);
    if ( busEvent == nn::cec::BusEventType_GoStandby )
    {
        NotifyCecSystemStandby();
    }
}

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer
