﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/spsm/detail/spsm_Log.h>
#include <nn/spsm/server/spsm_PowerStateMessageQueue.h>

#include "spsm_IEventHandler.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  AutoPowerDown 監視用クラス
//  idle から送られてくる自動スリープタイマー切れ (APD) のイベントを監視する
//
class AutoPowerDown final : public IEventHandler
{
public:
    void Initialize(nn::spsm::server::PowerStateMessageQueue*) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    void LinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_AutoPowerDownHolder);
    }
    void UnlinkMultiWaitHolders(os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_AutoPowerDownHolder);
    }
    bool HandleEventIfHolderOwner(os::MultiWaitHolderType* holder) NN_NOEXCEPT
    {
        if (holder == &m_AutoPowerDownHolder)
        {
            ProcessAutoPowerDown();
            return true;
        }
        return false;
    }

private:
    void ProcessAutoPowerDown() NN_NOEXCEPT;

    void NotifyAutoPowerDown() NN_NOEXCEPT
    {
        // NN_DETAIL_SPSM_INFO_V1("auto power down requested\n");
        m_pPowerStateMessageQueue->Enqueue(AddTimeStamp(nn::spsm::server::PowerStateMessage_EventAutoPowerDownTimerExpired));
    }

private:
    nn::spsm::server::PowerStateMessageQueue*    m_pPowerStateMessageQueue;

    os::SystemEventType     m_AutoPowerDown;
    os::MultiWaitHolderType m_AutoPowerDownHolder;
};

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

