﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/idle/idle_SystemApi.h>

#include "spsm_AutoPowerDown.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  初期化
//
void AutoPowerDown::Initialize(nn::spsm::server::PowerStateMessageQueue* pPowerStateMessageQueue) NN_NOEXCEPT
{
    m_pPowerStateMessageQueue = pPowerStateMessageQueue;

    nn::idle::InitializeForSystem();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::idle::GetAutoPowerDownEvent(&m_AutoPowerDown, os::EventClearMode_AutoClear));
    os::InitializeMultiWaitHolder(&m_AutoPowerDownHolder, &m_AutoPowerDown);

    m_AutoPowerDownHolder.userData = reinterpret_cast<uintptr_t>(this);
}

//-----------------------------------------------------------------------------
//  終了
//
void AutoPowerDown::Finalize() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder(&m_AutoPowerDownHolder);
    nn::os::DestroySystemEvent(&m_AutoPowerDown);
    nn::idle::FinalizeForSystem();
}


//-----------------------------------------------------------------------------
//  AutoPowerDown のハンドラ関数（多重待ち解除時に呼ばれる）
//
void AutoPowerDown::ProcessAutoPowerDown() NN_NOEXCEPT
{
    if (!nn::os::TryWaitSystemEvent(&m_AutoPowerDown))
    {
        return;
    }

    NotifyAutoPowerDown();
}

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

