﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }
}

namespace nn.time
{
    [CppRefPath(@"<nn/time/time_LocationName.h>")]
    [ExternalStruct(36, 1)]
    public struct LocationName
    {
    }

    [CppRefPath(@"<nn/time/time_SteadyClockTimePoint.h>")]
    [ExternalStruct(24, 8)]
    public struct SteadyClockTimePoint
    {
    }
}

namespace nn.util
{
    [CppRefPath(@"<nn/util/util_Uuid.h>")]
    [ExternalStruct(16, 8)]
    public struct Uuid
    {
    }
}

namespace nn.settings
{
    [CppRefPath(@"<nn/settings/settings_Language.h>")]
    [ExternalStruct(8, 1)]
    public struct LanguageCode
    {
    }

    [CppRefPath(@"<nn/settings/settings_ServiceTypes.h>")]
    [ExternalStruct(72, 1)]
    [LargeData]
    public struct SettingsName
    {
    }

    [CppRefPath(@"<nn/settings/settings_ServiceTypes.h>")]
    [ExternalStruct(72, 1)]
    [LargeData]
    public struct SettingsItemKey
    {
    }

    namespace system
    {
        [CppRefPath(@"<nn/settings/system/settings_Account.h>")]
        [ExternalStruct(4, 4)]
        public struct AccountSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Audio.h>")]
        [ExternalStruct(8, 4)]
        public struct AudioVolume
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Backlight.h>")]
        [ExternalStruct(40, 4)]
        public struct BacklightSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Backlight.h>")]
        [ExternalStruct(44, 4)]
        public struct BacklightSettingsEx
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_BatteryLot.h>")]
        [ExternalStruct(24, 1)]
        public struct BatteryLot
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_BluetoothDevices.h>")]
        [ExternalStruct(512, 4)]
        [LargeData]
        public struct BluetoothDevicesSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_BluetoothDevices.h>")]
        [ExternalStruct(128, 4)]
        [LargeData]
        public struct BlePairingSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Clock.h>")]
        [ExternalStruct(16, 1)]
        public struct ClockSourceId
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Clock.h>")]
        [ExternalStruct(32, 8)]
        public struct SystemClockContext
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_DataDeletion.h>")]
        [ExternalStruct(8, 4)]
        public struct DataDeletionSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Eula.h>")]
        [ExternalStruct(48, 8)]
        public struct EulaVersion
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Fatal.h>")]
        [ExternalStruct(16, 8)]
        public struct FatalDirtyFlagSet
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_FirmwareVersion.h>")]
        [ExternalStruct(256, 4)]
        [LargeData(true)]
        public struct FirmwareVersion
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_FirmwareVersion.h>")]
        [ExternalStruct(64, 1)]
        public struct FirmwareVersionDigest
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Hid.h>")]
        [ExternalStruct(41, 1)]
        public struct NxControllerSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Network.h>")]
        [ExternalStruct(432, 4)]
        [LargeData]
        public struct NetworkSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_News.h>")]
        [ExternalStruct(24, 4)]
        public struct NotificationSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_News.h>")]
        [ExternalStruct(24, 8)]
        public struct AccountNotificationSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_OnlineStorage.h>")]
        [ExternalStruct(24, 8)]
        public struct AccountOnlineStorageSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Ptm.h>")]
        [ExternalStruct(24, 1)]
        public struct PtmBatteryLot
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Ptm.h>")]
        [ExternalStruct(24, 4)]
        public struct PtmFuelGaugeParameter
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SerialNumber.h>")]
        [ExternalStruct(24, 1)]
        public struct SerialNumber
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SixAxisSensor.h>")]
        [ExternalStruct(12, 4)]
        public struct ConsoleSixAxisSensorAccelerationBias
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SixAxisSensor.h>")]
        [ExternalStruct(12, 4)]
        public struct ConsoleSixAxisSensorAngularVelocityBias
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SixAxisSensor.h>")]
        [ExternalStruct(12, 4)]
        public struct ConsoleSixAxisSensorAngularVelocityTimeBias
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SixAxisSensor.h>")]
        [ExternalStruct(36, 4)]
        public struct ConsoleSixAxisSensorAccelerationGain
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SixAxisSensor.h>")]
        [ExternalStruct(36, 4)]
        public struct ConsoleSixAxisSensorAngularVelocityGain
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SixAxisSensor.h>")]
        [ExternalStruct(36, 4)]
        public struct ConsoleSixAxisSensorAngularAcceleration
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Sleep.h>")]
        [ExternalStruct(12, 4)]
        public struct SleepSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SystemApplication.h>")]
        [ExternalStruct(32, 8)]
        public struct InitialLaunchSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SystemApplication.h>")]
        [ExternalStruct(128, 1)]
        [LargeData]
        public struct DeviceNickName
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_SystemApplication.h>")]
        [ExternalStruct(4, 4)]
        public struct AppletLaunchFlagSet
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Telemetry.h>")]
        [ExternalStruct(16, 8)]
        public struct TelemetryDirtyFlagSet
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Tv.h>")]
        [ExternalStruct(32, 4)]
        public struct TvSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Tv.h>")]
        [ExternalStruct(256, 1)]
        [LargeData]
        public struct Edid
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_ServiceDiscovery.h>")]
        [ExternalStruct(4, 4)]
        public struct ServiceDiscoveryControlSettings
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Web.h>")]
        [ExternalStruct(256, 1)]
        [LargeData]
        public struct AllowedSslHost
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Web.h>")]
        [ExternalStruct(256, 1)]
        [LargeData]
        public struct HostFsMountPoint
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_FirmwareVersion.h>")]
        [ExternalStruct(64, 4)]
        public struct RebootlessSystemUpdateVersion
        {
        }
    }

    public interface ISystemSettingsServer : IServiceObject
    {
        [MethodId(0)]
        Result SetLanguageCode(LanguageCode value);

        [MethodId(1)]
        Result SetNetworkSettings(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.NetworkSettings> values);

        [MethodId(2)]
        Result GetNetworkSettings(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.NetworkSettings> outValues);

        [MethodId(3)]
        Result GetFirmwareVersion(
            [BufferTransferMode(BufferTransferMode.PointerCopy)]
            Out<system.FirmwareVersion> outValue);

        [MethodId(4)]
        Result GetFirmwareVersion2(
            [BufferTransferMode(BufferTransferMode.PointerCopy)]
            Out<system.FirmwareVersion> outValue);

        [MethodId(5)]
        Result GetFirmwareVersionDigest(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<system.FirmwareVersionDigest> outValue);

        [MethodId(7)]
        Result GetLockScreenFlag(Out<bool> outValue);

        [MethodId(8)]
        Result SetLockScreenFlag(bool value);

        [MethodId(9)]
        Result GetBacklightSettings(Out<system.BacklightSettings> outValue);

        [MethodId(10)]
        Result SetBacklightSettings(system.BacklightSettings value);

        [MethodId(11)]
        Result SetBluetoothDevicesSettings(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.BluetoothDevicesSettings> values);

        [MethodId(12)]
        Result GetBluetoothDevicesSettings(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.BluetoothDevicesSettings> outValues);

        [MethodId(13)]
        Result GetExternalSteadyClockSourceId(
            Out<system.ClockSourceId> outValue);

        [MethodId(14)]
        Result SetExternalSteadyClockSourceId(system.ClockSourceId value);

        [MethodId(15)]
        Result GetUserSystemClockContext(
            Out<system.SystemClockContext> outValue);

        [MethodId(16)]
        Result SetUserSystemClockContext(system.SystemClockContext value);

        [MethodId(17)]
        Result GetAccountSettings(Out<system.AccountSettings> outValue);

        [MethodId(18)]
        Result SetAccountSettings(system.AccountSettings value);

        [MethodId(19)]
        Result GetAudioVolume(Out<system.AudioVolume> outValue, int32_t index);

        [MethodId(20)]
        Result SetAudioVolume(system.AudioVolume value, int32_t index);

        [MethodId(21)]
        Result GetEulaVersions(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.EulaVersion> outValues);

        [MethodId(22)]
        Result SetEulaVersions(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.EulaVersion> values);

        [MethodId(23)]
        Result GetColorSetId(Out<int32_t> outValue);

        [MethodId(24)]
        Result SetColorSetId(int32_t value);

        [MethodId(25)]
        Result GetConsoleInformationUploadFlag(Out<bool> outValue);

        [MethodId(26)]
        Result SetConsoleInformationUploadFlag(bool value);

        [MethodId(27)]
        Result GetAutomaticApplicationDownloadFlag(Out<bool> outValue);

        [MethodId(28)]
        Result SetAutomaticApplicationDownloadFlag(bool value);

        [MethodId(29)]
        Result GetNotificationSettings(
            Out<system.NotificationSettings> outValue);

        [MethodId(30)]
        Result SetNotificationSettings(system.NotificationSettings value);

        [MethodId(31)]
        Result GetAccountNotificationSettings(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.AccountNotificationSettings> outValues);

        [MethodId(32)]
        Result SetAccountNotificationSettings(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.AccountNotificationSettings> values);

        [MethodId(35)]
        Result GetVibrationMasterVolume(Out<float> outValue);

        [MethodId(36)]
        Result SetVibrationMasterVolume(float value);

        [MethodId(37)]
        Result GetSettingsItemValueSize(
            Out<uint64_t> outValue, SettingsName name, SettingsItemKey key);

        [MethodId(38)]
        Result GetSettingsItemValue(
            Out<uint64_t> outValue, OutBuffer buffer, SettingsName name,
            SettingsItemKey key);

        [MethodId(39)]
        Result GetTvSettings(Out<system.TvSettings> outValue);

        [MethodId(40)]
        Result SetTvSettings(system.TvSettings value);

        [MethodId(41)]
        Result GetEdid(Out<system.Edid> outValue);

        [MethodId(42)]
        Result SetEdid(system.Edid value);

        [MethodId(43)]
        Result GetAudioOutputMode(Out<int32_t> outValue, int32_t index);

        [MethodId(44)]
        Result SetAudioOutputMode(int32_t value, int32_t index);

        [MethodId(45)]
        Result IsForceMuteOnHeadphoneRemoved(Out<bool> outValue);

        [MethodId(46)]
        Result SetForceMuteOnHeadphoneRemoved(bool value);

        [MethodId(47)]
        Result GetQuestFlag(Out<bool> outValue);

        [MethodId(48)]
        Result SetQuestFlag(bool value);

        [MethodId(49)]
        Result GetDataDeletionSettings(
            Out<system.DataDeletionSettings> outValue);

        [MethodId(50)]
        Result SetDataDeletionSettings(system.DataDeletionSettings value);

        [MethodId(51)]
        Result GetInitialSystemAppletProgramId(Out<nn.ncm.ProgramId> outValue);

        [MethodId(52)]
        Result GetOverlayDispProgramId(Out<nn.ncm.ProgramId> outValue);

        [MethodId(53)]
        Result GetDeviceTimeZoneLocationName(
            Out<nn.time.LocationName> outValue);

        [MethodId(54)]
        Result SetDeviceTimeZoneLocationName(nn.time.LocationName value);

        [MethodId(55)]
        Result GetWirelessCertificationFileSize(Out<uint64_t> outValue);

        [MethodId(56)]
        Result GetWirelessCertificationFile(
            Out<uint64_t> outValue, OutBuffer outBuffer);

        [MethodId(57)]
        Result SetRegionCode(int32_t value);

        [MethodId(58)]
        Result GetNetworkSystemClockContext(
            Out<system.SystemClockContext> outValue);

        [MethodId(59)]
        Result SetNetworkSystemClockContext(system.SystemClockContext value);

        [MethodId(60)]
        Result IsUserSystemClockAutomaticCorrectionEnabled(Out<bool> outValue);

        [MethodId(61)]
        Result SetUserSystemClockAutomaticCorrectionEnabled(bool value);

        [MethodId(62)]
        Result GetDebugModeFlag(Out<bool> outValue);

        [MethodId(63)]
        Result GetPrimaryAlbumStorage(Out<int> outValue);

        [MethodId(64)]
        Result SetPrimaryAlbumStorage(int value);

        [MethodId(65)]
        Result GetUsb30EnableFlag(Out<bool> outValue);

        [MethodId(66)]
        Result SetUsb30EnableFlag(bool value);

        [MethodId(67)]
        Result GetBatteryLot(Out<system.BatteryLot> outValue);

        [MethodId(68)]
        Result GetSerialNumber(Out<system.SerialNumber> outValue);

        [MethodId(69)]
        Result GetNfcEnableFlag(Out<bool> outValue);

        [MethodId(70)]
        Result SetNfcEnableFlag(bool value);

        [MethodId(71)]
        Result GetSleepSettings(Out<system.SleepSettings> outValue);

        [MethodId(72)]
        Result SetSleepSettings(system.SleepSettings value);

        [MethodId(73)]
        Result GetWirelessLanEnableFlag(Out<bool> outValue);

        [MethodId(74)]
        Result SetWirelessLanEnableFlag(bool value);

        [MethodId(75)]
        Result GetInitialLaunchSettings(
            Out<system.InitialLaunchSettings> outValue);

        [MethodId(76)]
        Result SetInitialLaunchSettings(system.InitialLaunchSettings value);

        [MethodId(77)]
        Result GetDeviceNickName(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<system.DeviceNickName> outValue);

        [MethodId(78)]
        Result SetDeviceNickName(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            system.DeviceNickName value);

        [MethodId(79)]
        Result GetProductModel(Out<int32_t> outValue);

        [MethodId(80)]
        Result GetLdnChannel(Out<int32_t> outValue);

        [MethodId(81)]
        Result SetLdnChannel(int32_t value);

        [MethodId(82)]
        Result AcquireTelemetryDirtyFlagEventHandle(Out<NativeHandle> outValue);

        [MethodId(83)]
        Result GetTelemetryDirtyFlags(
            Out<system.TelemetryDirtyFlagSet> outValue);

        [MethodId(84)]
        Result GetPtmBatteryLot(Out<system.PtmBatteryLot> outValue);

        [MethodId(85)]
        Result SetPtmBatteryLot(system.PtmBatteryLot value);

        [MethodId(86)]
        Result GetPtmFuelGaugeParameter(
            Out<system.PtmFuelGaugeParameter> outValue);

        [MethodId(87)]
        Result SetPtmFuelGaugeParameter(system.PtmFuelGaugeParameter value);

        [MethodId(88)]
        Result GetBluetoothEnableFlag(Out<bool> outValue);

        [MethodId(89)]
        Result SetBluetoothEnableFlag(bool value);

        [MethodId(90)]
        Result GetMiiAuthorId(Out<nn.util.Uuid> outValue);

        [MethodId(91)]
        Result SetShutdownRtcValue(int64_t value);

        [MethodId(92)]
        Result GetShutdownRtcValue(Out<int64_t> outValue);

        [MethodId(93)]
        Result AcquireFatalDirtyFlagEventHandle(Out<NativeHandle> outValue);

        [MethodId(94)]
        Result GetFatalDirtyFlags(Out<system.FatalDirtyFlagSet> outValue);

        [MethodId(95)]
        Result GetAutoUpdateEnableFlag(Out<bool> outValue);

        [MethodId(96)]
        Result SetAutoUpdateEnableFlag(bool value);

        [MethodId(97)]
        Result GetNxControllerSettings(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.NxControllerSettings> outValues);

        [MethodId(98)]
        Result SetNxControllerSettings(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.NxControllerSettings> values);

        [MethodId(99)]
        Result GetBatteryPercentageFlag(Out<bool> outValue);

        [MethodId(100)]
        Result SetBatteryPercentageFlag(bool value);

        [MethodId(101)]
        Result GetExternalRtcResetFlag(Out<bool> outValue);

        [MethodId(102)]
        Result SetExternalRtcResetFlag(bool value);

        [MethodId(103)]
        Result GetUsbFullKeyEnableFlag(Out<bool> outValue);

        [MethodId(104)]
        Result SetUsbFullKeyEnableFlag(bool value);

        [MethodId(105)]
        Result SetExternalSteadyClockInternalOffset(int64_t value);

        [MethodId(106)]
        Result GetExternalSteadyClockInternalOffset(Out<int64_t> outValue);

        [MethodId(107)]
        Result GetBacklightSettingsEx(Out<system.BacklightSettingsEx> outValue);

        [MethodId(108)]
        Result SetBacklightSettingsEx(system.BacklightSettingsEx value);

        [MethodId(109)]
        Result GetHeadphoneVolumeWarningCount(Out<int32_t> outValue);

        [MethodId(110)]
        Result SetHeadphoneVolumeWarningCount(int32_t value);

        [MethodId(111)]
        Result GetBluetoothAfhEnableFlag(Out<bool> outValue);

        [MethodId(112)]
        Result SetBluetoothAfhEnableFlag(bool value);

        [MethodId(113)]
        Result GetBluetoothBoostEnableFlag(Out<bool> outValue);

        [MethodId(114)]
        Result SetBluetoothBoostEnableFlag(bool value);

        [MethodId(115)]
        Result GetInRepairProcessEnableFlag(Out<bool> outValue);

        [MethodId(116)]
        Result SetInRepairProcessEnableFlag(bool value);

        [MethodId(117)]
        Result GetHeadphoneVolumeUpdateFlag(Out<bool> outValue);

        [MethodId(118)]
        Result SetHeadphoneVolumeUpdateFlag(bool value);

        [MethodId(119)]
        Result NeedsToUpdateHeadphoneVolume(
            Out<bool> outValue,
            Out<bool> outIsHighPowerAvailable,
            Out<int8_t> outVolume,
            bool isRestricted);

        [MethodId(120)]
        Result GetPushNotificationActivityModeOnSleep(Out<int32_t> outValue);

        [MethodId(121)]
        Result SetPushNotificationActivityModeOnSleep(int32_t value);

        [MethodId(122)]
        Result GetServiceDiscoveryControlSettings(
            Out<nn.settings.system.ServiceDiscoveryControlSettings> outValue);

        [MethodId(123)]
        Result SetServiceDiscoveryControlSettings(
            nn.settings.system.ServiceDiscoveryControlSettings value);

        [MethodId(124)]
        Result GetErrorReportSharePermission(Out<int32_t> outValue);

        [MethodId(125)]
        Result SetErrorReportSharePermission(int32_t value);

        [MethodId(126)]
        Result GetAppletLaunchFlags(Out<system.AppletLaunchFlagSet> outValue);

        [MethodId(127)]
        Result SetAppletLaunchFlags(system.AppletLaunchFlagSet value);

        [MethodId(128)]
        Result GetConsoleSixAxisSensorAccelerationBias(
            Out<system.ConsoleSixAxisSensorAccelerationBias> outValue);

        [MethodId(129)]
        Result SetConsoleSixAxisSensorAccelerationBias(
            system.ConsoleSixAxisSensorAccelerationBias value);

        [MethodId(130)]
        Result GetConsoleSixAxisSensorAngularVelocityBias(
            Out<system.ConsoleSixAxisSensorAngularVelocityBias> outValue);

        [MethodId(131)]
        Result SetConsoleSixAxisSensorAngularVelocityBias(
            system.ConsoleSixAxisSensorAngularVelocityBias value);

        [MethodId(132)]
        Result GetConsoleSixAxisSensorAccelerationGain(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<system.ConsoleSixAxisSensorAccelerationGain> outValue);

        [MethodId(133)]
        Result SetConsoleSixAxisSensorAccelerationGain(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            system.ConsoleSixAxisSensorAccelerationGain value);

        [MethodId(134)]
        Result GetConsoleSixAxisSensorAngularVelocityGain(
            Out<system.ConsoleSixAxisSensorAngularVelocityGain> outValue);

        [MethodId(135)]
        Result SetConsoleSixAxisSensorAngularVelocityGain(
            system.ConsoleSixAxisSensorAngularVelocityGain value);

        [MethodId(136)]
        Result GetKeyboardLayout(Out<int32_t> outValue);

        [MethodId(137)]
        Result SetKeyboardLayout(int32_t value);

        [MethodId(138)]
        Result GetWebInspectorFlag(Out<bool> outValue);

        [MethodId(139)]
        Result GetAllowedSslHosts(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.AllowedSslHost> outValues);

        [MethodId(140)]
        Result GetHostFsMountPoint(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<system.HostFsMountPoint> outValue);

        [MethodId(141)]
        Result GetRequiresRunRepairTimeReviser(Out<bool> outValue);

        [MethodId(142)]
        Result SetRequiresRunRepairTimeReviser(bool value);

        [MethodId(143)]
        Result SetBlePairingSettings(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.BlePairingSettings> values);

        [MethodId(144)]
        Result GetBlePairingSettings(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.BlePairingSettings> outValues);

        [MethodId(145)]
        Result GetConsoleSixAxisSensorAngularVelocityTimeBias(
            Out<system.ConsoleSixAxisSensorAngularVelocityTimeBias> outValue);

        [MethodId(146)]
        Result SetConsoleSixAxisSensorAngularVelocityTimeBias(
            system.ConsoleSixAxisSensorAngularVelocityTimeBias value);

        [MethodId(147)]
        Result GetConsoleSixAxisSensorAngularAcceleration(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<system.ConsoleSixAxisSensorAngularAcceleration> outValue);

        [MethodId(148)]
        Result SetConsoleSixAxisSensorAngularAcceleration(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            system.ConsoleSixAxisSensorAngularAcceleration value);

        [MethodId(149)]
        Result GetRebootlessSystemUpdateVersion(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<system.RebootlessSystemUpdateVersion> outValue);

        [MethodId(150)]
        Result GetDeviceTimeZoneLocationUpdatedTime(
            Out<nn.time.SteadyClockTimePoint> outValue);

        [MethodId(151)]
        Result SetDeviceTimeZoneLocationUpdatedTime(
            nn.time.SteadyClockTimePoint value);

        [MethodId(152)]
        Result GetUserSystemClockAutomaticCorrectionUpdatedTime(
            Out<nn.time.SteadyClockTimePoint> outValue);

        [MethodId(153)]
        Result SetUserSystemClockAutomaticCorrectionUpdatedTime(
            nn.time.SteadyClockTimePoint value);

        [MethodId(154)]
        Result GetAccountOnlineStorageSettings(
            Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            OutArray<system.AccountOnlineStorageSettings> outValues);

        [MethodId(155)]
        Result SetAccountOnlineStorageSettings(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.AccountOnlineStorageSettings> values);
    }
}
