﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.settings
{
    [CppRefPath(@"<nn/settings/settings_ServiceTypes.h>")]
    [ExternalStruct(72, 1)]
    [LargeData]
    public struct SettingsName
    {
    }

    [CppRefPath(@"<nn/settings/settings_ServiceTypes.h>")]
    [ExternalStruct(72, 1)]
    [LargeData]
    public struct SettingsItemKey
    {
    }

    namespace fwdbg
    {
        [CppRefPath(@"<nn/settings/fwdbg/settings_SettingsGetterApi.h>")]
        [ExternalStruct(16, 8)]
        public struct SettingsItemKeyIterator
        {
        }
    }

    namespace system
    {
        [CppRefPath(@"<nn/settings/system/settings_Web.h>")]
        [ExternalStruct(256, 1)]
        [LargeData]
        public struct AllowedSslHost
        {
        }

        [CppRefPath(@"<nn/settings/system/settings_Web.h>")]
        [ExternalStruct(256, 1)]
        [LargeData]
        public struct HostFsMountPoint
        {
        }
    }

    [CppRefPath(@"<nn/settings/settings_IFirmwareDebugSettingsServer.sfdl.h>")]
    public interface ISettingsItemKeyIterator : IServiceObject
    {
        [MethodId(0)]
        Result GoNext();

        [MethodId(1)]
        Result GetKeySize(Out<uint64_t> outValue);

        [MethodId(2)]
        Result GetKey(Out<uint64_t> outValue, OutBuffer buffer);
    }

    [CppRefPath(@"<nn/settings/settings_IFirmwareDebugSettingsServer.sfdl.h>")]
    public interface IFirmwareDebugSettingsServer : IServiceObject
    {
        [MethodId(2)]
        Result SetSettingsItemValue(
            SettingsName name, SettingsItemKey key, InBuffer value);

        [MethodId(3)]
        Result ResetSettingsItemValue(SettingsName name, SettingsItemKey key);

        [MethodId(4)]
        Result CreateSettingsItemKeyIterator(
            Out<ISettingsItemKeyIterator> outValue, SettingsName name);

        [MethodId(10)]
        Result ReadSettings(
            Out<uint64_t> outCount, OutBuffer buffer, int32_t target);

        [MethodId(11)]
        Result ResetSettings(int32_t target);

        [MethodId(20)]
        Result SetWebInspectorFlag(bool value);

        [MethodId(21)]
        Result SetAllowedSslHosts(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<system.AllowedSslHost> values);

        [MethodId(22)]
        Result SetHostFsMountPoint(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            system.HostFsMountPoint value);
    }
}
