﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/settings/settings_SystemApplication.h>
#include <nn/settings/system/settings_SystemApplication.h>

#include "detail/settings_SystemApplicationImpl.h"

namespace nn { namespace settings {

bool GetQuestFlag() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetQuestFlagForApplication(&value));
    return value;
}

}} // nn::settings

namespace nn { namespace settings { namespace system {

bool GetLockScreenFlag() NN_NOEXCEPT
{
    bool value = true;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetLockScreenFlag(&value));
    return value;
}

void SetLockScreenFlag(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetLockScreenFlag(value));
}

int32_t GetColorSetId() NN_NOEXCEPT
{
    auto value = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetColorSetId(&value));
    return value;
}

void SetColorSetId(int32_t value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetColorSetId(value));
}

void GetInitialLaunchSettings(InitialLaunchSettings* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetInitialLaunchSettings(pOutValue));
}

void SetInitialLaunchSettings(const InitialLaunchSettings& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetInitialLaunchSettings(value));
}

void GetDeviceNickName(DeviceNickName* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetDeviceNickName(pOutValue));
}

void SetDeviceNickName(const DeviceNickName& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetDeviceNickName(value));
}

bool GetBatteryPercentageFlag() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetBatteryPercentageFlag(&value));
    return value;
}

void SetBatteryPercentageFlag(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetBatteryPercentageFlag(value));
}

void GetAppletLaunchFlags(AppletLaunchFlagSet* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetAppletLaunchFlags(pOutValue));
}

void SetAppletLaunchFlags(const AppletLaunchFlagSet& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetAppletLaunchFlags(value));
}

bool GetQuestFlag() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetQuestFlagForSystemApplication(&value));
    return value;
}

void SetQuestFlag(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetQuestFlag(value));
}

size_t GetWirelessCertificationFileSize() NN_NOEXCEPT
{
    auto value = uint64_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetWirelessCertificationFileSize(&value));
    return static_cast<size_t>(value);
}

size_t GetWirelessCertificationFile(void* outBuffer, size_t size) NN_NOEXCEPT
{
    auto value = uint64_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetWirelessCertificationFile(
            &value, outBuffer, static_cast<uint64_t>(size)));
    return static_cast<size_t>(value);
}

}}} // namespace nn::settings::system
