﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_News.h>

#include "detail/settings_NewsImpl.h"

namespace nn { namespace settings { namespace system {

bool GetAutomaticApplicationDownloadFlag() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetAutomaticApplicationDownloadFlag(&value));
    return value;
}

void SetAutomaticApplicationDownloadFlag(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetAutomaticApplicationDownloadFlag(value));
}

void GetNotificationSettings(NotificationSettings* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetNotificationSettings(pOutValue));
}

void SetNotificationSettings(const NotificationSettings& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetNotificationSettings(value));
}

int GetAccountNotificationSettings(
    AccountNotificationSettings outValues[], int count) NN_NOEXCEPT
{
    auto outCount = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetAccountNotificationSettings(
            &outCount, outValues, static_cast<size_t>(::std::max(0, count))));
    return outCount;
}

void SetAccountNotificationSettings(
    const AccountNotificationSettings values[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetAccountNotificationSettings(
            values, static_cast<size_t>(::std::max(0, count))));
}

}}} // namespace nn::settings::system
