﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Clock.h>

#include "detail/settings_ClockImpl.h"

namespace nn { namespace settings { namespace system {

void GetExternalSteadyClockSourceId(ClockSourceId* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetExternalSteadyClockSourceId(pOutValue));
}

void SetExternalSteadyClockSourceId(const ClockSourceId& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetExternalSteadyClockSourceId(value));
}

int64_t GetShutdownRtcValue() NN_NOEXCEPT
{
    auto value = int64_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetShutdownRtcValue(&value));
    return value;
}

void SetShutdownRtcValue(int64_t value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetShutdownRtcValue(value));
}

int64_t GetExternalSteadyClockInternalOffset() NN_NOEXCEPT
{
    auto value = int64_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetExternalSteadyClockInternalOffset(&value));
    return value;
}

void SetExternalSteadyClockInternalOffset(int64_t value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetExternalSteadyClockInternalOffset(value));
}

void GetUserSystemClockContext(SystemClockContext* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetUserSystemClockContext(pOutValue));
}

void SetUserSystemClockContext(const SystemClockContext& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetUserSystemClockContext(value));
}

void GetNetworkSystemClockContext(SystemClockContext* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetNetworkSystemClockContext(pOutValue));
}

void SetNetworkSystemClockContext(const SystemClockContext& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetNetworkSystemClockContext(value));
}

bool IsUserSystemClockAutomaticCorrectionEnabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::IsUserSystemClockAutomaticCorrectionEnabled(
            &value));
    return value;
}

void SetUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetUserSystemClockAutomaticCorrectionEnabled(
            value));
}

void GetUserSystemClockAutomaticCorrectionUpdatedTime(
    ::nn::time::SteadyClockTimePoint* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetUserSystemClockAutomaticCorrectionUpdatedTime(
            pOutValue));
}

void SetUserSystemClockAutomaticCorrectionUpdatedTime(
    const ::nn::time::SteadyClockTimePoint& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetUserSystemClockAutomaticCorrectionUpdatedTime(
            value));
}

}}} // namespace nn::settings::system
