﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/settings/factory/settings_Amiibo.h>
#include <nn/settings/factory/settings_Result.h>

#include "detail/settings_AmiiboImpl.h"

namespace nn { namespace settings { namespace factory {

::nn::Result GetAmiiboKey(AmiiboKey* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result = ::nn::settings::detail::GetAmiiboKey(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetAmiiboEcqvCertificate(
    AmiiboEcqvCertificate* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetAmiiboEcqvCertificate(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetAmiiboEcdsaCertificate(
    AmiiboEcdsaCertificate* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetAmiiboEcdsaCertificate(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetAmiiboEcqvBlsKey(AmiiboEcqvBlsKey* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetAmiiboEcqvBlsKey(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetAmiiboEcqvBlsCertificate(
    AmiiboEcqvBlsCertificate* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetAmiiboEcqvBlsCertificate(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetAmiiboEcqvBlsRootCertificate(
    AmiiboEcqvBlsRootCertificate* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetAmiiboEcqvBlsRootCertificate(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

}}} // namespace nn::settings::factory
