﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_Windows.h>

namespace nn { namespace settings { namespace detail {

//!< システムデータファイルを扱うクラスです。
class SystemDataFile final
{
private:
    //!< ファイル名の接頭辞の最大長
    static const int PrefixLengthMax = 31;

    //!< ファイル名の接頭辞
    char m_Prefix[PrefixLengthMax + 1];

    //!< ファイル操作排他用ミューテックスの名前
    char m_MutexName[MAX_PATH];

    //!< ファイル操作排他用ミューテックスのハンドル
    HANDLE m_MutexHandle;

    //!< ファイルパス
    char m_FilePath[MAX_PATH];

    //!< ファイルハンドル
    HANDLE m_FileHandle;

public:
    SystemDataFile() NN_NOEXCEPT;

    explicit SystemDataFile(const SystemDataFile& that) NN_NOEXCEPT;

    //!< ファイル名の接頭辞を設定します。
    void SetPrefix(const char* prefix) NN_NOEXCEPT;

    //!< マウント名を設定します。
    void SetMountName(const char* name) NN_NOEXCEPT;

    //!< ファイルシステムをマウントします。
    ::nn::Result Mount(bool creates) NN_NOEXCEPT;

    //!< システムデータファイルを作成します。
    ::nn::Result Create(int64_t size) NN_NOEXCEPT;

    //!< システムデータファイルを読み込み権限で開きます。
    ::nn::Result OpenToRead() NN_NOEXCEPT;

    //!< システムデータファイルを書き込み権限で開きます。
    ::nn::Result OpenToWrite() NN_NOEXCEPT;

    //!< システムデータファイルを閉じます。
    void Close() NN_NOEXCEPT;

    //!< システムデータファイルから読み込みます。
    ::nn::Result Read(int64_t offset, void* buffer, size_t size) NN_NOEXCEPT;

    //!< システムデータファイルへ書き込みます。
    ::nn::Result Write(
        int64_t offset, const void* buffer, size_t size) NN_NOEXCEPT;

    //!< システムデータファイルへの書き込みをフラッシュします。
    ::nn::Result Flush() NN_NOEXCEPT;
};

}}} // namespace nn::settings::detail
