﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>

#include "settings_StringBuilder.h"

namespace nn { namespace settings { namespace detail {

char* WriteString(char* buffer, int size, char value) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES_RANGE(size, 2, size + 1);
    NN_SDK_REQUIRES_NOT_EQUAL('\0', value);
    NN_UNUSED(size);
    *buffer = value;
    ++buffer;
    *buffer = '\0';
    return buffer;
}

char* WriteString(char* buffer, int size, const char* value) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES_RANGE(size, 1, size + 1);
    NN_SDK_REQUIRES_NOT_NULL(value);
    const char* const tail = buffer + size - 1;
    while (buffer < tail && *value != '\0')
    {
        *(buffer++) = *(value++);
    }
    NN_SDK_ASSERT_EQUAL('\0', *value);
    *buffer = '\0';
    return buffer;
}

}}} // namespace nn::settings::detail
