﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_SixAxisSensor.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetConsoleSixAxisSensorAccelerationBias(
    ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias* pOutValue) NN_NOEXCEPT;

::nn::Result SetConsoleSixAxisSensorAccelerationBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias& value) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorAngularVelocityBias(
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias* pOutValue) NN_NOEXCEPT;

::nn::Result SetConsoleSixAxisSensorAngularVelocityBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias& value) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorAccelerationGain(
    ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain* pOutValue) NN_NOEXCEPT;

::nn::Result SetConsoleSixAxisSensorAccelerationGain(
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain& value) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorAngularVelocityGain(
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain* pOutValue) NN_NOEXCEPT;

::nn::Result SetConsoleSixAxisSensorAngularVelocityGain(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain& value) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorAngularVelocityTimeBias(
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias* pOutValue) NN_NOEXCEPT;

::nn::Result SetConsoleSixAxisSensorAngularVelocityTimeBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias& value) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorAngularAcceleration(
    ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration* pOutValue) NN_NOEXCEPT;

::nn::Result SetConsoleSixAxisSensorAngularAcceleration(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration& value) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
