﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/kpr/kpr_KeyCode.h>
#include <nn/settings/settings_ISettingsServer.sfdl.h>
#include <nn/settings/settings_Language.h>

namespace nn { namespace settings { namespace detail {

//!< 設定サービスを扱うクラスです。
class SettingsServer final
{
    NN_DISALLOW_COPY(SettingsServer);
    NN_DISALLOW_MOVE(SettingsServer);

public:
    SettingsServer() NN_NOEXCEPT;

    ::nn::Result GetLanguageCode(
        ::nn::sf::Out<::nn::settings::LanguageCode> value) NN_NOEXCEPT;

    ::nn::Result GetAvailableLanguageCodes(
        ::nn::sf::Out<int32_t> outCount,
        const ::nn::sf::OutArray<::nn::settings::LanguageCode>& outCodes
        ) NN_NOEXCEPT;

    ::nn::Result MakeLanguageCode(
        ::nn::sf::Out<::nn::settings::LanguageCode> outValue,
        int32_t value) NN_NOEXCEPT;

    ::nn::Result GetAvailableLanguageCodeCount(
        ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result GetRegionCode(::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result GetAvailableLanguageCodes2(
        ::nn::sf::Out<int32_t> outCount,
        const ::nn::sf::OutArray<::nn::settings::LanguageCode>& outCodes
        ) NN_NOEXCEPT;

    ::nn::Result GetAvailableLanguageCodeCount2(
        ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result GetKeyCodeMap(
        ::nn::sf::Out<::nn::kpr::KeyCodeMap> outValue) NN_NOEXCEPT;

    ::nn::Result GetQuestFlag(::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result GetKeyCodeMap2(
        ::nn::sf::Out<::nn::kpr::KeyCodeMap> outValue) NN_NOEXCEPT;
};

//!< 設定サービスのプロクシを作成します。
::nn::Result CreateSettingsServerProxy(
    ::nn::sf::SharedPointer<ISettingsServer>* pOutValue) NN_NOEXCEPT;

}}}
