﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/settings/settings_IFactorySettingsServer.sfdl.h>
#include <nn/settings/factory/settings_Amiibo.h>
#include <nn/settings/factory/settings_Bluetooth.h>
#include <nn/settings/factory/settings_ConfigurationId.h>
#include <nn/settings/factory/settings_DeviceCertificate.h>
#include <nn/settings/factory/settings_DeviceKey.h>
#include <nn/settings/factory/settings_MotionSensor.h>
#include <nn/settings/factory/settings_SerialNumber.h>
#include <nn/settings/factory/settings_Speaker.h>
#include <nn/settings/factory/settings_WirelessLan.h>

namespace nn { namespace settings { namespace detail {

//!< 生産時設定サービスを扱うクラスです。
class FactorySettingsServer final
{
    NN_DISALLOW_COPY(FactorySettingsServer);
    NN_DISALLOW_MOVE(FactorySettingsServer);

public:
    FactorySettingsServer() NN_NOEXCEPT;

    ::nn::Result GetBluetoothBdAddress(
        ::nn::sf::Out<::nn::settings::factory::BdAddress> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetConfigurationId1(
        ::nn::sf::Out<::nn::settings::factory::ConfigurationId1> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAccelerometerOffset(
        ::nn::sf::Out<::nn::settings::factory::AccelerometerOffset> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAccelerometerScale(
        ::nn::sf::Out<::nn::settings::factory::AccelerometerScale> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetGyroscopeOffset(
        ::nn::sf::Out<::nn::settings::factory::GyroscopeOffset> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetGyroscopeScale(
        ::nn::sf::Out<::nn::settings::factory::GyroscopeScale> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetWirelessLanMacAddress(
        ::nn::sf::Out<::nn::settings::factory::MacAddress> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetWirelessLanCountryCodeCount(
        ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result GetWirelessLanCountryCodes(
        ::nn::sf::Out<int32_t> outValue,
        const ::nn::sf::OutArray<
            ::nn::settings::factory::CountryCode>& outCodes) NN_NOEXCEPT;

    ::nn::Result GetSerialNumber(
        ::nn::sf::Out<::nn::settings::factory::SerialNumber> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetInitialSystemAppletProgramId(
        ::nn::ncm::ProgramId value) NN_NOEXCEPT;

    ::nn::Result SetOverlayDispProgramId(
        ::nn::ncm::ProgramId value) NN_NOEXCEPT;

    ::nn::Result GetBatteryLot(
        ::nn::sf::Out<nn::settings::factory::BatteryLot> outValue) NN_NOEXCEPT;

    ::nn::Result GetEciDeviceCertificate(
        ::nn::sf::Out<
            ::nn::settings::factory::EccB233DeviceCertificate> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetEticketDeviceCertificate(
        ::nn::sf::Out<
            ::nn::settings::factory::Rsa2048DeviceCertificate> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetSslKey(
        ::nn::sf::Out<::nn::settings::factory::SslKey> outValue) NN_NOEXCEPT;

    ::nn::Result GetSslCertificate(
        ::nn::sf::Out<
            ::nn::settings::factory::SslCertificate> outValue) NN_NOEXCEPT;

    ::nn::Result GetGameCardKey(
        ::nn::sf::Out<
            ::nn::settings::factory::GameCardKey> outValue) NN_NOEXCEPT;

    ::nn::Result GetGameCardCertificate(
        ::nn::sf::Out<
            ::nn::settings::factory::GameCardCertificate> outValue) NN_NOEXCEPT;

    ::nn::Result GetEciDeviceKey(
        ::nn::sf::Out<
            ::nn::settings::factory::EccB233DeviceKey> outValue) NN_NOEXCEPT;

    ::nn::Result GetEticketDeviceKey(
        ::nn::sf::Out<
            ::nn::settings::factory::Rsa2048DeviceKey> outValue) NN_NOEXCEPT;

    ::nn::Result GetSpeakerParameter(
        ::nn::sf::Out<
            ::nn::settings::factory::SpeakerParameter> outValue) NN_NOEXCEPT;

    ::nn::Result GetLcdVendorId(::nn::sf::Out<uint32_t> outValue) NN_NOEXCEPT;

    ::nn::Result GetEciDeviceCertificate2(
        ::nn::sf::Out<
            ::nn::settings::factory::Rsa2048DeviceCertificate> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetEciDeviceKey2(
        ::nn::sf::Out<::nn::settings::factory::Rsa2048DeviceKey> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAmiiboKey(
        ::nn::sf::Out<::nn::settings::factory::AmiiboKey> outValue) NN_NOEXCEPT;

    ::nn::Result GetAmiiboEcqvCertificate(
        ::nn::sf::Out<::nn::settings::factory::AmiiboEcqvCertificate> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAmiiboEcdsaCertificate(
        ::nn::sf::Out<::nn::settings::factory::AmiiboEcdsaCertificate> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAmiiboEcqvBlsKey(
        ::nn::sf::Out<::nn::settings::factory::AmiiboEcqvBlsKey> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAmiiboEcqvBlsCertificate(
        ::nn::sf::Out<
            ::nn::settings::factory::AmiiboEcqvBlsCertificate> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAmiiboEcqvBlsRootCertificate(
        ::nn::sf::Out<
            ::nn::settings::factory::AmiiboEcqvBlsRootCertificate> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetUsbTypeCPowerSourceCircuitVersion(
        ::nn::sf::Out<::nn::Bit8> outValue) NN_NOEXCEPT;
};

//!< 生産時設定サービスのプロクシを作成します。
::nn::Result CreateFactorySettingsServerProxy(
    ::nn::sf::SharedPointer<IFactorySettingsServer>* pOutValue
    ) NN_NOEXCEPT;

}}}
