﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Eula.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetEulaVersions(int32_t* pOutCount,
                             ::nn::settings::system::EulaVersion outValues[],
                             int count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(
        pProxy->GetEulaVersions(
            pOutCount,
            ::nn::sf::OutArray<::nn::settings::system::EulaVersion>(
                outValues,
                static_cast<size_t>(count < 0 ? 0 : count))));
    NN_RESULT_SUCCESS;
}

::nn::Result SetEulaVersions(const ::nn::settings::system::EulaVersion values[],
                             int count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(
        pProxy->SetEulaVersions(
            ::nn::sf::InArray<::nn::settings::system::EulaVersion>(
                values,
                static_cast<size_t>(count < 0 ? 0 : count))));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
