﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/settings/factory/settings_Amiibo.h>
#include <nn/settings/factory/settings_BatteryLot.h>
#include <nn/settings/factory/settings_Bluetooth.h>
#include <nn/settings/factory/settings_ConfigurationId.h>
#include <nn/settings/factory/settings_DeviceCertificate.h>
#include <nn/settings/factory/settings_DeviceKey.h>
#include <nn/settings/factory/settings_GameCard.h>
#include <nn/settings/factory/settings_MotionSensor.h>
#include <nn/settings/factory/settings_SerialNumber.h>
#include <nn/settings/factory/settings_Speaker.h>
#include <nn/settings/factory/settings_Ssl.h>
#include <nn/settings/factory/settings_WirelessLan.h>
#include <nn/settings/system/settings_BatteryLot.h>
#include <nn/settings/system/settings_SerialNumber.h>
#include <nn/util/util_MathTypes.h>

namespace nn { namespace settings { namespace detail {

//!< 生産時設定の amiibo 用本体秘密鍵を取得します。
::nn::Result GetCalibBinAmiiboKey(
    ::nn::settings::factory::AmiiboKey* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の amiibo 用 ECQV 証明書を取得します。
::nn::Result GetCalibBinAmiiboEcqvCertificate(
    ::nn::settings::factory::AmiiboEcqvCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の amiibo 用 ECDSA 証明書を取得します。
::nn::Result GetCalibBinAmiiboEcdsaCertificate(
    ::nn::settings::factory::AmiiboEcdsaCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の amiibo 用本体秘密鍵 (ECQV-BLS 版) を取得します。
::nn::Result GetCalibBinAmiiboEcqvBlsKey(
    ::nn::settings::factory::AmiiboEcqvBlsKey* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の amiibo 用 ECQV-BLS 証明書を取得します。
::nn::Result GetCalibBinAmiiboEcqvBlsCertificate(
    ::nn::settings::factory::AmiiboEcqvBlsCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の amiibo 用ルート証明書 (ECQV-BLS 版) を取得します。
::nn::Result GetCalibBinAmiiboEcqvBlsRootCertificate(
    ::nn::settings::factory::AmiiboEcqvBlsRootCertificate* pOutValue
    ) NN_NOEXCEPT;

//!< 生産時設定の Bluetooth に対して設定された BD アドレスを取得します。
::nn::Result GetCalibBinBluetoothBdAddress(
    ::nn::settings::factory::BdAddress* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の構成識別子 1 を取得します。
::nn::Result GetCalibBinConfigurationId1(
    ::nn::settings::factory::ConfigurationId1* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の加速度センサのオフセット値を取得します。
::nn::Result GetCalibBinAccelerometerOffset(
    ::nn::settings::factory::AccelerometerOffset* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の加速度センサのスケール値を取得します。
::nn::Result GetCalibBinAccelerometerScale(
    ::nn::settings::factory::AccelerometerScale* pOutValue) NN_NOEXCEPT;

//!< 生産時設定のジャイロスコープのオフセット値を取得します。
::nn::Result GetCalibBinGyroscopeOffset(
    ::nn::settings::factory::GyroscopeOffset* pOutValue) NN_NOEXCEPT;

//!< 生産時設定のジャイロスコープのスケール値を取得します。
::nn::Result GetCalibBinGyroscopeScale(
    ::nn::settings::factory::GyroscopeScale* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の製品シリアル番号を取得します。
::nn::Result GetCalibBinSerialNumber(
    ::nn::settings::factory::SerialNumber* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の製品シリアル番号をシステム設定向けに取得します
::nn::Result GetCalibBinSerialNumberForSystemSettings(
    ::nn::settings::system::SerialNumber* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の無線 LAN に対して設定された MAC アドレスを取得します。
::nn::Result GetCalibBinWirelessLanMacAddress(
    ::nn::settings::factory::MacAddress* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の無線 LAN に対して設定された国名コードの数を取得します。
::nn::Result GetCalibBinWirelessLanCountryCodeCount(
    int32_t* pOutCount) NN_NOEXCEPT;

//!< 生産時設定の無線 LAN に対して設定された国名コードを取得します。
::nn::Result GetCalibBinWirelessLanCountryCodes(
    int32_t* pOutCount,
    ::nn::settings::factory::CountryCode outCodes[],
    size_t count) NN_NOEXCEPT;

//!< 生産時設定の電池 LOT を取得します
::nn::Result GetCalibBinBatteryLot(
    ::nn::settings::factory::BatteryLot* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の電池 LOT をシステム設定向けに取得します
::nn::Result GetCalibBinBatteryLotForSystemSettings(
    ::nn::settings::system::BatteryLot* pOutValue) NN_NOEXCEPT;

//!< 生産時設定のスピーカーのパラメータを取得します。
::nn::Result GetCalibBinSpeakerParameter(
    ::nn::settings::factory::SpeakerParameter* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の ECC-B233 版のデバイス登録用デバイス証明書を取得します。
::nn::Result GetCalibBinEccB233DeviceCertificate(
    ::nn::settings::factory::EccB233DeviceCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の RSA-2048 版のデバイス登録用デバイス証明書を取得します。
::nn::Result GetCalibBinRsa2048DeviceCertificate(
    ::nn::settings::factory::Rsa2048DeviceCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の RSA-2048 版の eTicket 発行用デバイス証明書を取得します。
::nn::Result GetCalibBinRsa2048ETicketCertificate(
    ::nn::settings::factory::Rsa2048DeviceCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の製品モデルをシステム設定向けに取得します
::nn::Result GetCalibBinProductModelForSystemSettings(
    int32_t* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の SSL クライアント秘密鍵を取得します。
::nn::Result GetCalibBinSslKey(
    ::nn::settings::factory::SslKey* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の SSL クライアント証明書を取得します。
::nn::Result GetCalibBinSslCertificate(
    ::nn::settings::factory::SslCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定のゲームカード相互認証秘密鍵を取得します。
::nn::Result GetCalibBinGameCardKey(
    ::nn::settings::factory::GameCardKey* pOutValue) NN_NOEXCEPT;

//!< 生産時設定のゲームカード相互認証証明書を取得します。
::nn::Result GetCalibBinGameCardCertificate(
    ::nn::settings::factory::GameCardCertificate* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の ECC-B233 版のデバイス登録用デバイス秘密鍵を取得します。
::nn::Result GetCalibBinEccB233DeviceKey(
    ::nn::settings::factory::EccB233DeviceKey* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の RSA-2048 版のデバイス登録用デバイス秘密鍵を取得します。
::nn::Result GetCalibBinRsa2048DeviceKey(
    ::nn::settings::factory::Rsa2048DeviceKey* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の RSA-2048 版の eTicket 発行用デバイス秘密鍵を取得します。
::nn::Result GetCalibBinRsa2048ETicketKey(
    ::nn::settings::factory::Rsa2048DeviceKey* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の輝度レベルからバックライト出力への変換係数を内部実装向けに取得します。
::nn::Result GetCalibBinBacklightBrightnessCoefficientsForInternal(
    ::nn::util::Float3* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の LCD ベンダ ID を取得します。
::nn::Result GetCalibBinLcdVendorId(uint32_t* pOutValue) NN_NOEXCEPT;

//!< 生産時設定の USB Type-C Power Source 回路バージョンを取得します。
::nn::Result GetCalibBinUsbTypeCPowerSourceCircuitVersion(
    ::nn::Bit8* pOutValue) NN_NOEXCEPT;

}}} // nn::settings::detail
