﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Audio.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_AudioImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetAudioVolume(
    ::nn::settings::system::AudioVolume* pOutValue, int32_t index) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetAudioVolume(pOutValue, index));

    NN_RESULT_SUCCESS;
}

::nn::Result SetAudioVolume(
    const ::nn::settings::system::AudioVolume& value, int32_t index) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetAudioVolume(value, index));

    NN_RESULT_SUCCESS;
}

::nn::Result GetAudioOutputMode(int32_t* pOutValue, int32_t index) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetAudioOutputMode(pOutValue, index));

    NN_RESULT_SUCCESS;
}

::nn::Result SetAudioOutputMode(int32_t value, int32_t index) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetAudioOutputMode(value, index));

    NN_RESULT_SUCCESS;
}

::nn::Result IsForceMuteOnHeadphoneRemoved(bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->IsForceMuteOnHeadphoneRemoved(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetForceMuteOnHeadphoneRemoved(bool forceMute) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetForceMuteOnHeadphoneRemoved(forceMute));

    NN_RESULT_SUCCESS;
}

::nn::Result GetHeadphoneVolumeWarningCount(int32_t* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetHeadphoneVolumeWarningCount(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetHeadphoneVolumeWarningCount(int32_t value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetHeadphoneVolumeWarningCount(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetHeadphoneVolumeUpdateFlag(bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetHeadphoneVolumeUpdateFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetHeadphoneVolumeUpdateFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetHeadphoneVolumeUpdateFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result NeedsToUpdateHeadphoneVolume(
    bool* pOutValue, bool* pOutIsHighPowerAvailable, int8_t* pOutVolume,
    bool isRestricted) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->NeedsToUpdateHeadphoneVolume(
        pOutValue, pOutIsHighPowerAvailable, pOutVolume, isRestricted));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
