﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_IFactorySettingsServer.sfdl.h>
#include <nn/settings/factory/settings_Amiibo.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_AmiiboImpl.h"
#include "settings_FactorySettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetAmiiboKey(
    ::nn::settings::factory::AmiiboKey* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAmiiboKey(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAmiiboEcqvCertificate(
    ::nn::settings::factory::AmiiboEcqvCertificate* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAmiiboEcqvCertificate(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAmiiboEcdsaCertificate(
    ::nn::settings::factory::AmiiboEcdsaCertificate* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAmiiboEcdsaCertificate(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAmiiboEcqvBlsKey(
    ::nn::settings::factory::AmiiboEcqvBlsKey* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAmiiboEcqvBlsKey(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAmiiboEcqvBlsCertificate(
    ::nn::settings::factory::AmiiboEcqvBlsCertificate* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAmiiboEcqvBlsCertificate(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAmiiboEcqvBlsRootCertificate(
    ::nn::settings::factory::AmiiboEcqvBlsRootCertificate* pOutValue
    ) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAmiiboEcqvBlsRootCertificate(pOutValue));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
