﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/psm/psm_ManufactureTypes.h>

#include "psm_PowerSupplyManager.h"
#include "psm_ISupplyRouteDriver.h"
#include "psm_ModuleHolder.h"

namespace nn { namespace psm { namespace driver { namespace detail {

void PowerSupplyManager::EnableSupplyRouteControl() NN_NOEXCEPT
{
    m_ModuleHolder.EnableSupplyRouteControl();
}

void PowerSupplyManager::DisableSupplyRouteControl() NN_NOEXCEPT
{
    m_ModuleHolder.DisableSupplyRouteControl();
}

void PowerSupplyManager::SetSupplyRoute(::nn::psm::SupplyRoute supplyRoute) NN_NOEXCEPT
{
    ::nn::psm::driver::detail::SupplyRoute hardwareSupplyRoute = ::nn::psm::driver::detail::SupplyRoute_Invalid;

    switch ( supplyRoute )
    {
    case ::nn::psm::SupplyRoute_None:
        hardwareSupplyRoute = ::nn::psm::driver::detail::SupplyRoute_None;
        break;
    case ::nn::psm::SupplyRoute_Vdd50A:
        hardwareSupplyRoute = ::nn::psm::driver::detail::SupplyRoute_Vdd50A;
        break;
    case ::nn::psm::SupplyRoute_Vdd50B:
        hardwareSupplyRoute = ::nn::psm::driver::detail::SupplyRoute_Vdd50B;
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }

    NN_SDK_ASSERT(hardwareSupplyRoute != ::nn::psm::driver::detail::SupplyRoute_Invalid);

    m_pSupplyRouteDriver->SetSupplyRoute(hardwareSupplyRoute);
}

}}}} // namespace nn::psm::driver::detail
