﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nne/max17050/max17050.h>

namespace nn { namespace psm { namespace driver { namespace detail {

static const ::nne::max17050::CustomParameters CustomParametersForAtl =
{
    0x203B, // relaxcfg
    0x0053, // rcomp0
    0x1C22, // tempco
    0x0333, // ichgterm
    0xE1F6, // tgain
    0x2BF2, // toff
    0xA05F, // vempty
    0x5786, // qrtable00
    0x3184, // qrtable01
    0x1E00, // qrtable02
    0x1502, // qrtable03
    0x2476, // capacity
    0x2476, // vffullcap
    {   /* 0x80 */
        0x9FF0, 0xAD30, 0xB5D0, 0xB9C0, 0xBAD0, 0xBBE0, 0xBC30, 0xBC90,
        0xBCE0, 0xBD40, 0xBE70, 0xC0E0, 0xC4E0, 0xC890, 0xCC90, 0xD0F0,
        /* 0x90 */
        0x0170, 0x0480, 0x0590, 0x0BE0, 0x0A00, 0x3C00, 0x3810, 0x3A00,
        0x3A30, 0x19F0, 0x0EF0, 0x0AF0, 0x0BD0, 0x07F0, 0x06F0, 0x06F0,
        /* 0xA0 */
        0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
        0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200
    } // modelTable
};

static const ::nne::max17050::CustomParameters CustomParametersForMaxell =
{
    0x203B, // relaxcfg
    0x0085, // rcomp0
    0x1625, // tempco
    0x0333, // ichgterm
    0xE1F6, // tgain
    0x2BF2, // toff
    0xa05f, // vempty
    0x3100, // qrtable00
    0x1b00, // qrtable01
    0x1000, // qrtable02
    0x0c81, // qrtable03
    0x227a, // capacity
    0x227a, // vffullcap
    {   /* 0x80 */
        0xa340, 0xb840, 0xb900, 0xbb70, 0xbc90, 0xbd20, 0xbdc0, 0xbea0,
        0xbf70, 0xc030, 0xc210, 0xc3f0, 0xc800, 0xc9e0, 0xcca0, 0xd090,
        /* 0x90 */
        0x0160, 0x3800, 0x0800, 0x1e00, 0x2550, 0x3060, 0x15d0, 0x1810,
        0x1490, 0x0b80, 0x0bf0, 0x0af0, 0x0cb0, 0x06f0, 0x09d0, 0x09d0,
        /* 0xA0 */
        0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
        0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100
    } // modelTable
};

}}}} // namespace nn::psm::driver::detail
