﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include "psm_EventHolder.h"

namespace nn { namespace psm { namespace driver { namespace detail {

bool EventHolder::IsBoundEvent() NN_NOEXCEPT
{
    if (m_pEvent != nullptr)
    {
        return true;
    }
    return false;
}

void EventHolder::DestroyEvent() NN_NOEXCEPT
{
    ::std::lock_guard<decltype(m_EventHolderMutex)> lock(m_EventHolderMutex);
    NN_SDK_ASSERT_NOT_NULL(m_pEvent);
    ::nn::os::DestroySystemEvent(m_pEvent);
}

void EventHolder::AttachEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    ::std::lock_guard<decltype(m_EventHolderMutex)> lock(m_EventHolderMutex);
    m_pEvent = pEvent;
}

void EventHolder::DetachEvent() NN_NOEXCEPT
{
    ::std::lock_guard<decltype(m_EventHolderMutex)> lock(m_EventHolderMutex);
    m_pEvent = nullptr;
}

nn::os::SystemEventType* EventHolder::GetSystemEvent() NN_NOEXCEPT
{
    return m_pEvent;
}

}}}} // namespace nn::psm::driver::detail
