﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/os.h>

#include "../psm_IUsbPowerManager.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

//! USB Power Delivery のイベントの処理を行うクラス
class UsbPowerDeliveryEventHandler final : public EventHandler
{
    NN_DISALLOW_COPY(UsbPowerDeliveryEventHandler);
    NN_DISALLOW_MOVE(UsbPowerDeliveryEventHandler);

public:
    UsbPowerDeliveryEventHandler() NN_NOEXCEPT;

    virtual ~UsbPowerDeliveryEventHandler() NN_NOEXCEPT NN_OVERRIDE;

    void Initialize(IUsbPowerManager* pUsbPowerManager) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

    //! テスト用途で USB PD のハンドリング完了イベントへのポインタを返します。
    ::nn::Result GetEventForTest(::nn::os::EventType** pOutEventPointer) NN_NOEXCEPT;

private:
    //! USB の電源関連のマネージャー
    IUsbPowerManager* m_pUsbPowerManager;

    //! USB::PD の割り込みを検出するイベント
    ::nn::os::MultiWaitHolderType m_MultiWaitHolder;

    //! テスト用途の USB PD のハンドリング完了イベント
    ::nn::os::EventType m_EventForTest;
};

}}}} // namespace nn::psm::driver::detail
