﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

#include "../psm_IFuelGaugeParameterManager.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class PeriodicCustomParameterSaver final : public EventHandler
{
    NN_DISALLOW_COPY(PeriodicCustomParameterSaver);
    NN_DISALLOW_MOVE(PeriodicCustomParameterSaver);

public:
    PeriodicCustomParameterSaver() NN_NOEXCEPT;

    virtual ~PeriodicCustomParameterSaver() NN_NOEXCEPT NN_OVERRIDE;

    void Initialize(IFuelGaugeParameterManager* pFuelGaugeParameterManager) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    void StartPeriodicTimerEvent() NN_NOEXCEPT;

    void StopTimerEvent() NN_NOEXCEPT;

    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

private:
    IFuelGaugeParameterManager* m_pFuelGaugeParameterManager;

    //! 電池残量計パラメータを定期的に保存するイベント
    ::nn::os::TimerEventType m_PeriodicCustomParameterSaveEvent;
    ::nn::os::MultiWaitHolderType m_PeriodicCustomParameterSaveMultiWaitHolder;
};

}}}} // namespace nn::psm::driver::detail
