﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

namespace nn { namespace psm { namespace driver { namespace detail {

class EventHandler
{
    NN_DISALLOW_COPY(EventHandler);
    NN_DISALLOW_MOVE(EventHandler);

public:
    EventHandler() NN_NOEXCEPT {}

    virtual ~EventHandler() NN_NOEXCEPT {};

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT = 0;

    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT = 0;

    virtual bool HandleEvent() NN_NOEXCEPT = 0;
};

}}}} // namespace nn::psm::driver::detail
