﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_HipcServer.h>
#include <nn/psc/psc_Types.h>
#include <nn/psc/sfdl/psc.sfdl.h>


namespace nn     {
namespace psc    {
namespace server {

class PmModule;

class PmModuleSfObject :
    public nn::sf::ISharedObject
{
private:
    PmModule* m_pModule;

public:
    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, PmModuleId moduleId, const nn::sf::InBuffer& clients)
    NN_NOEXCEPT;

    nn::Result Finalize()
    NN_NOEXCEPT;

    nn::Result GetRequest(nn::sf::Out<PmState> state, nn::sf::Out<PmFlagSet> flags)
    NN_NOEXCEPT;

    nn::Result Acknowledge()
    NN_NOEXCEPT;

    nn::Result AcknowledgeEx(PmState state)
    NN_NOEXCEPT;

    PmModuleSfObject()
    NN_NOEXCEPT;

    ~PmModuleSfObject()
    NN_NOEXCEPT;
};

}}}
