﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>

#include <nn/nn_SdkAssert.h>

namespace nn { namespace profiler {

struct SharedArea
{
    uint32_t get;
    uint32_t put;
    uint32_t numCallstacks;
    char ring[];

    SharedArea() : get(0), put(0), numCallstacks(0) {}
};

template <int Capacity>
struct Buffer
{
    char buf[Capacity];
    size_t size;

    Buffer() : size(0)
    {
        memset(buf, 0, Capacity);
    }

    void Write(const void *data, size_t bytes)
    {
        NN_SDK_ASSERT(size + bytes <= Capacity);
        memcpy(buf + size, data, bytes);
        size += bytes;
    }

    template <typename T>
    void Write(T data)
    {
        Write(&data, sizeof(data));
    }

    int GetCapacity() { return Capacity; }
};

const size_t SharedMemorySizeMax = 8 * 1024;
const size_t RingSize = SharedMemorySizeMax - sizeof(SharedArea);


void InitializeMemoryProfilerServer(SharedArea* data);
bool IsConnectedToMemoryProfilerServer();
void SendMemoryEventToPc();
void FinalizeMemoryProfilerServer();


}} // nn::profiler
