﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/os/os_NativeHandle.h>

#include "profiler_CommMessages.h"
#include "profiler_IpcEvent.h"

namespace nn { namespace profiler {

    extern nn::os::SystemEventType     g_ProfilerProcessEvent;

    void InitializeProfilerProcess() NN_NOEXCEPT;
    void FinalizeProfilerProcess() NN_NOEXCEPT;
    bool IsProfilerProcessInitialized() NN_NOEXCEPT;

    //void StartSignalingProfilerEvent(int64_t interval, int coreCount) NN_NOEXCEPT;
    //void StopSignalingProfilerEvent() NN_NOEXCEPT;

    nn::Result LibraryInitialize(uint32_t sdkVersion) NN_NOEXCEPT;
    nn::Result LibraryFinalize() NN_NOEXCEPT;
    ProfilerStatus GetProfilerStatusFromServer() NN_NOEXCEPT;
    nn::Result GetIpcEvent(IpcEventInfo* pOutEvent) NN_NOEXCEPT;
    nn::Result CloseAndGetNextBuffer(nn::os::NativeHandle* pOutBuffer, size_t filledSize, uint32_t index) NN_NOEXCEPT;
    nn::Result CloseAndFinalizeBuffer(size_t filledSize, uint32_t index) NN_NOEXCEPT;
    nn::Result SendMessageToPc(uint32_t id, const void* buffer, size_t size, bool callback) NN_NOEXCEPT;
    nn::Result StartMultipartMessageToPc(uint32_t id, uint64_t totalSize, uint32_t pieces, bool callback) NN_NOEXCEPT;
    nn::Result SendMultipartMessageToPc(const void* buffer, size_t size, int remaining) NN_NOEXCEPT;
    nn::Result GetGlobalProfileSettings(void* buffer, size_t size) NN_NOEXCEPT;
    nn::Result SetGlobalProfileSettings(
        uint32_t affinityMask,
        uint32_t flags,
        uint32_t performanceCounterGroup,
        uint32_t sampleRate) NN_NOEXCEPT;
    nn::Result TransferSampleBuffers(nn::os::NativeHandle transferMemHandle, uintptr_t originalAddress, size_t size) NN_NOEXCEPT;
    nn::Result SendSampleBufferAsMultipart(uint32_t blockId, size_t size, int remaining) NN_NOEXCEPT;
    bool IsPcSynced() NN_NOEXCEPT;
    nn::Result SendBufferToProcess(const void* buffer, size_t size, SendBufferType type) NN_NOEXCEPT;
    nn::Result SendBasicIpcMessage(ProfilerIpcMessage message, uint64_t data) NN_NOEXCEPT;

    nn::Result SetupTransferMemory(void* startAddress, size_t size);
    nn::Result DestroyTransferMemory();

}} // namespace nn::profiler
