﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn
{
    [CppRefPath(@"<nn/nn_ApplicationId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }
}

namespace nn.account
{
    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid
    {
    }
}

namespace nn.prepo
{
    [CppRefPath(@"<nn/prepo/prepo_TypesDebug.h>")]
    [ExternalStruct(256, 8)]
    [LargeData]
    public struct Statistics
    {
    }
}

namespace nn.prepo
{
    [CppRefPath(@"<nn/prepo/prepo_TypesDebug.h>")]
    [ExternalStruct(4, 2)]
    public struct ThroughputRecord
    {
    }
}

namespace nn.prepo.detail.ipc
{
    [CppRefPath(@"<nn/prepo/detail/ipc/prepo_IPrepoService.sfdl.h>")]
    public partial interface IPrepoService : IServiceObject {}

    ////////////////////////////////////////////////////////////////////////////////
    // Generic API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IPrepoService : IServiceObject
    {
        [MethodId(10100)]
        Result SaveReport(InArray<char_t> eventId, InBuffer data, [ProcessId] Bit64 processId);

        [MethodId(10101)]
        Result SaveReportWithUser(nn.account.Uid uid,
            InArray<char_t> eventId, InBuffer data, [ProcessId] Bit64 processId);

        [MethodId(10200)]
        Result RequestImmediateTransmission();

        [MethodId(10300)]
        Result GetTransmissionStatus(Out<int32_t> outStatus);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // System API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IPrepoService : IServiceObject
    {
        [MethodId(20100)]
        Result SaveSystemReport(InArray<char_t> eventId, nn.ApplicationId appId, InBuffer data);

        [MethodId(20101)]
        Result SaveSystemReportWithUser(nn.account.Uid uid,
            InArray<char_t> eventId, nn.ApplicationId appId, InBuffer data);

        [MethodId(20200)]
        Result SetOperationMode(int64_t mode);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Manager API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IPrepoService : IServiceObject
    {
        [MethodId(30100)]
        Result ClearStorage();

        [MethodId(30200)]
        Result ClearStatistics();
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Config API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IPrepoService : IServiceObject
    {
        [MethodId(40100)]
        Result IsUserAgreementCheckEnabled(Out<bool> outIsEnabled);

        [MethodId(40101)]
        Result SetUserAgreementCheckEnabled(bool isEnabled);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Debug API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface IPrepoService : IServiceObject
    {
        [MethodId(90100)]
        Result GetStorageUsage(Out<int64_t> outUsed, Out<int64_t> outCapacity);

        [MethodId(90200)]
        Result GetStatistics([BufferTransferMode(BufferTransferMode.MapAlias)] Out<Statistics> outStatistics);

        [MethodId(90201)]
        Result GetThroughputHistory(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ThroughputRecord> outArray);

        [MethodId(90300)]
        Result GetLastUploadError();
    }
}
