﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/prepo_ApiConfig.h>
#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/detail/prepo_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace prepo {

nn::Result IsUserAgreementCheckEnabled(bool* outIsEnabled) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outIsEnabled);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_RESULT_DO(session->IsUserAgreementCheckEnabled(outIsEnabled));

    NN_RESULT_SUCCESS;
}

nn::Result SetUserAgreementCheckEnabled(bool isEnabled) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_RESULT_DO(session->SetUserAgreementCheckEnabled(isEnabled));

    NN_RESULT_SUCCESS;
}

}}
