﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/service/core/prepo_DeviceAuthenticationToken.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

namespace
{
    const uint64_t ClinetId = 0xdf51c436bc01c437;
}

DeviceAuthenticationToken::DeviceAuthenticationToken() NN_NOEXCEPT
{
}

nn::Result DeviceAuthenticationToken::Get(const char** pOutToken, bool forceUpdate) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutToken);

    nn::TimeSpan expiresIn;
    int tokenSize;

    NN_RESULT_DO(nn::dauth::AcquireDeviceAuthenticationToken(
        &expiresIn, &tokenSize, m_AuthToken, sizeof(m_AuthToken), ClinetId,
        forceUpdate, nullptr));

    NN_SDK_ASSERT_EQUAL(m_AuthToken[tokenSize], '\0');

    *pOutToken = m_AuthToken;

    NN_RESULT_SUCCESS;
}

}}}}}
