﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/prepo_ShimLibraryGlobal.h>
#include <nn/util/util_LockGuard.h>

namespace nn { namespace prepo { namespace detail {

ShimLibraryGlobal::ShimLibraryGlobal() NN_NOEXCEPT :
    m_Session(nullptr)
{
}

void ShimLibraryGlobal::Initialize() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);

    if (!m_Session)
    {
        GetIpcSession();
    }
}

detail::ipc::IPrepoService* ShimLibraryGlobal::GetSession() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(m_Mutex);

    if (!m_Session)
    {
        GetIpcSession();
    }

    return m_Session;
}

void ShimLibraryGlobal::GetIpcSession() NN_NOEXCEPT
{
    detail::ipc::Initialize();
    m_Session = detail::ipc::GetPrepoService();
}

}}}
