﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/pl/srv/pl_ServiceName.h>
#include <nn/pl/srv/pl_SharedFontManagerServer.h>

namespace nn { namespace pl { namespace srv {

namespace
{
    nn::sf::UnmanagedServiceObject<nn::pl::detail::ISharedFontManager, nn::pl::srv::SharedFontManagerServer> g_ServiceObject;

    class ServerManager : public nn::sf::HipcSimpleAllInOneServerManager<5, 1>
    {
    };

    std::aligned_storage<sizeof(ServerManager), NN_ALIGNOF(ServerManager)>::type g_ServerManagerStorage;
    ServerManager* g_pServerManager;
}

void CreateServer() NN_NOEXCEPT
{
    g_ServiceObject.GetImpl().Initialize();

    NN_SDK_ASSERT(!g_pServerManager);
    g_pServerManager = new (&g_ServerManagerStorage) ServerManager;
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pServerManager->RegisterObjectForPort(g_ServiceObject.GetShared(), 5, nn::pl::ServiceNameForApplication ));
}

void StartServer() NN_NOEXCEPT
{
    g_pServerManager->Start();
}

void LoopAuto() NN_NOEXCEPT
{
    g_pServerManager->LoopAuto();
}

void RequestStopServer() NN_NOEXCEPT
{
    g_pServerManager->RequestStop();
}

void DestroyServer() NN_NOEXCEPT
{
    g_pServerManager->~ServerManager();
    g_pServerManager = nullptr;
}

}}}
