﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.perflog.sf
{
    [CppRefPath(@"<nn/perflog/sfdl/perflog.sfdl.h>")]
    public interface IDaemon : IServiceObject
    {
        // ---------------------
        // RegisterTrigger
        // called by log sources to register a dump trigger event.
        // must pass writeable handle so the daemon can trigger it.
        [MethodId(0)]
        Result RegisterTrigger(
            nn.sf.InBuffer name,
            NativeHandle dumpTriggerHandle );


        // -------------------
        // BeginDump, DumpLine, EndDump
        // called by log sources to send data stored in the log
        [MethodId(1)]
        Result BeginDump(
            Out<uint64_t> pOutCookie );

        [MethodId(2)]
        Result DumpLine(
            uint64_t cookie, // obtained from BeginDump
            uint64_t thread,
            uint64_t timestamp,
            uint32_t id,
            nn.sf.InBuffer context );

        [MethodId(3)]
        Result EndDump(
            uint64_t cookie );


        // -------------------
        // TriggerDump: called by log utility to
        // dump one or more logs (name with * at the end is ok)
        [MethodId(4)]
        Result TriggerDump(
            nn.sf.InBuffer name );

        // -------------------
        // UnregisterTrigger: called by sources,
        // undoes RegisterTrigger registration
        [MethodId(5)]
        Result UnregisterTrigger(
            nn.sf.InBuffer name );

        // -------------------
        // TEST PURPOSE
        [MethodId(6)]
        Result TestRegisterEvent(
            NativeHandle testTriggerHandle );

        // -------------------
        // TEST PURPOSE
        [MethodId(7)]
        Result TestTriggerEvent();

        // -------------------
        // TEST PURPOSE
        [MethodId(8)]
        Result TestUnregisterEvent();
    }

}

