﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// NOTE:
// this file is made only to demonstrate remote triggering of a writable event

#include "perflog_DaemonImpl.h"
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_SystemEventApi.h>
#include <nn/os/os_Result.public.h>


// Implemention for the perflog daemon ServiceFramework interface
// This class keeps a dictionary of handles, each associated with a name
// provided by clients.
// It then provides the service of triggering these event handles
// by name on behalf of other clients


namespace nn { namespace perflog {


nn::Result DaemonImpl::TestRegisterEvent(
    nn::sf::NativeHandle&& signalHandle ) NN_NOEXCEPT
{
    if( m_TestEvent.GetOsHandle() != nn::os::InvalidNativeHandle )
    {
        NN_SDK_LOG( "XDBG: TestRegisterEvent: called when already registered\n" );
        return ResultNotSupported();
    }
    else
    {
        m_TestEvent = std::move( signalHandle );
        NN_SDK_LOG( "XDBG: TestRegisterEvent handle=%x\n", m_TestEvent.GetOsHandle() );
        NN_SDK_ASSERT( m_TestEvent.IsManaged() ); // we need this to close the handle
        NN_RESULT_SUCCESS;
    }
}


nn::Result DaemonImpl::TestTriggerEvent() NN_NOEXCEPT
{
    if( m_TestEvent.GetOsHandle() == nn::os::InvalidNativeHandle )
    {
        NN_SDK_LOG( "XDBG: TestTriggerEvent: called when not yet registered\n" );
        return ResultNotSupported();
    }
    else
    {
        nn::os::SystemEventType evt;
        nn::os::AttachWritableHandleToSystemEvent(&evt,
                                                  m_TestEvent.GetOsHandle(), false,
                                                  nn::os::EventClearMode_AutoClear  );
        nn::os::SignalSystemEvent(&evt);
        nn::os::DetachWritableHandleOfSystemEvent(&evt);
        NN_SDK_LOG( "XDBG: v4: TestTriggerEvent successfully signaled handle %x\n", m_TestEvent.GetOsHandle() );
        NN_RESULT_SUCCESS;
    }
}


nn::Result DaemonImpl::TestUnregisterEvent() NN_NOEXCEPT
{
    if( m_TestEvent.GetOsHandle() == nn::os::InvalidNativeHandle )
    {
        NN_SDK_LOG( "XDBG: TestUnregisterEvent: called when not yet registered\n" );
        return ResultNotSupported();
    }
    else
    {
        nn::sf::NativeHandle destroy = std::move( m_TestEvent );
        NN_SDK_ASSERT( !m_TestEvent.IsManaged() );
        NN_SDK_ASSERT( m_TestEvent.GetOsHandle() == nn::os::InvalidNativeHandle );
        NN_SDK_LOG( "XDBG: TestUnregisterEvent: successful\n" );
        NN_RESULT_SUCCESS;
    }
}


}}  // nn::perflog

