﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/perflog/sfdl/perflog.sfdl.h>

// Declaration for the perflog daemon ServiceFramework interface


namespace nn { namespace perflog {

class DaemonImpl
{
public:
    DaemonImpl() NN_NOEXCEPT;

public:
    nn::Result RegisterTrigger(
          const nn::sf::InBuffer& pNameAsBuffer,
          nn::sf::NativeHandle&& signalHandle ) NN_NOEXCEPT;

    nn::Result BeginDump(
          nn::sf::Out<uint64_t> cookie ) NN_NOEXCEPT;

    nn::Result DumpLine(
          uint64_t cookie,
          uint64_t thread,
          uint64_t timestamp,
          uint32_t id,
          const nn::sf::InBuffer& pContextAsBuffer ) NN_NOEXCEPT;

    nn::Result EndDump(
          uint64_t cookie ) NN_NOEXCEPT;

    nn::Result TriggerDump(
          const nn::sf::InBuffer& pNameAsBuffer ) NN_NOEXCEPT;

    nn::Result UnregisterTrigger(
          const nn::sf::InBuffer& pNameAsBuffer ) NN_NOEXCEPT;

    nn::Result TestRegisterEvent(
          nn::sf::NativeHandle&& signalHandle ) NN_NOEXCEPT;

    nn::Result TestTriggerEvent() NN_NOEXCEPT;

    nn::Result TestUnregisterEvent() NN_NOEXCEPT;

private: // constants
    static const uint32_t MaxEntries = 16;
    static const uint32_t MaxNameLen = 32;

private: // types
    struct Entry
    {
        char name[ MaxNameLen ];
        nn::sf::NativeHandle event;
    };

private: // utilities
    Entry* FindFreeEntry( ) NN_NOEXCEPT;
    bool MatchEntry( const char* mask, const char* candidateName ) NN_NOEXCEPT;
    bool IsNameInUse(const char* evName) NN_NOEXCEPT;

private: // data
    Entry m_Entries[MaxEntries];
    uint64_t m_NextDumpCookie;
    nn::sf::NativeHandle m_TestEvent;
};

}}  // nn::perflog

