﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn
{
    [CppRefPath(@"<nn/nn_ApplicationId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId { }
}

namespace nn.account
{
    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid { }

    [CppRefPath("<nn/account/account_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct NetworkServiceAccountId { }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_StorageId.h>")]
    [ExternalStruct(1, 1)]
    public struct StorageId { }

    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId { }

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId { }
}

namespace nn.ns
{
    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(1, 1)]
    public struct PlayLogPolicy{}
}

namespace nn.pdm
{
    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(1, 1)]
    public struct AppletEventType { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(1, 1)]
    public struct UserAccountEventType { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(1, 1)]
    public struct OperationMode { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(1, 1)]
    public struct PowerStateChangeEventType { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(12, 4)]
    public struct EventTimeData { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(32, 8)]
    public struct DetailedEventTimeData { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(24, 8)]
    public struct ApplicationEvent { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(56, 8)]
    public struct AccountEvent { }

    [CppRefPath(@"<nn/pdm/pdm_SystemTypes.h>")]
    [ExternalStruct(40, 8)]
    public struct PlayStatistics { }

    [CppRefPath(@"<nn/pdm/pdm_QueryLastPlayTimeApi.h>")]
    [ExternalStruct(24, 8)]
    public struct LastPlayTime { }

    [CppRefPath(@"<nn/pdm/pdm_PrivateTypes.h>")]
    [ExternalStruct(56, 8)]
    public struct PlayEvent { }

    [CppRefPath(@"<nn/pdm/pdm_PrivateTypes.h>")]
    [ExternalStruct(40, 8)]
    public struct AccountPlayEvent { }

    [CppRefPath(@"<nn/pdm/pdm_Types.h>")]
    [ExternalStruct(24, 8)]
    public struct ApplicationPlayStatistics { }
}

namespace nn.pdm.detail
{
    public interface INotifyService : IServiceObject
    {
        [MethodId(0)]
        Result NotifyAppletEvent(nn.pdm.AppletEventType eventType, nn.ncm.ProgramId programId, uint32_t version, uint8_t appletId, nn.ncm.StorageId storageId, nn.ns.PlayLogPolicy logPolicy);

        [MethodId(2)]
        Result NotifyOperationModeChangeEvent(nn.pdm.OperationMode eventType);

        [MethodId(3)]
        Result NotifyPowerStateChangeEvent(nn.pdm.PowerStateChangeEventType eventType);

        [MethodId(4)]
        Result NotifyClearAllEvent();

        [MethodId(5)]
        Result NotifyEventForDebug([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.pdm.PlayEvent> playEventArray);

        [MethodId(6)]
        Result SuspendUserAccountEventService(nn.account.Uid user);

        [MethodId(7)]
        Result ResumeUserAccountEventService(nn.account.Uid user);

        [MethodId(8)]
        Result NotifyLibraryAppletEvent(nn.pdm.AppletEventType eventType, nn.ncm.ProgramId mainProgramId, uint8_t libraryAppletMode, uint8_t appletId, nn.ncm.StorageId storageId, nn.ns.PlayLogPolicy logPolicy);
    }

    public interface IQueryService : IServiceObject
    {
        [MethodId(0)]
        Result QueryApplicationEvent(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationEvent> outList, int eventIndexOffset);

        [MethodId(1)]
        Result QueryPlayStatistics(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<PlayStatistics> outList);

        [MethodId(2)]
        Result QueryPlayStatisticsByUserAccountId(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<PlayStatistics> outList, nn.account.Uid user);

        [MethodId(3)]
        Result QueryPlayStatisticsByNetworkServiceAccountId(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<PlayStatistics> outList, nn.account.NetworkServiceAccountId networkServiceAccountId);

        [MethodId(4)]
        Result QueryPlayStatisticsByApplicationId(Out<PlayStatistics> outValue, nn.ncm.ApplicationId applicationId);

        [MethodId(5)]
        Result QueryPlayStatisticsByApplicationIdAndUserAccountId(Out<PlayStatistics> outValue, nn.ncm.ApplicationId applicationId, nn.account.Uid user);

        [MethodId(6)]
        Result QueryPlayStatisticsByApplicationIdAndNetworkServiceAccountId(Out<PlayStatistics> outValue, nn.ncm.ApplicationId applicationId, nn.account.NetworkServiceAccountId networkServiceAccountId);

        [MethodId(7)]
        Result QueryLastPlayTime(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<LastPlayTime> outList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.ApplicationId> applicationIdList);

        [MethodId(8)]
        Result QueryPlayEvent(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<PlayEvent> outList, int offset);

        [MethodId(9)]
        Result GetAvailablePlayEventRange(Out<int> outCount, Out<int> startIndex, Out<int> lastIndex);

        [MethodId(10)]
        Result QueryAccountEvent(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<AccountEvent> outList, int eventIndexOffset);

        [MethodId(11)]
        Result QueryAccountPlayEvent(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<AccountPlayEvent> outList, int offset, nn.account.Uid user);

        [MethodId(12)]
        Result GetAvailableAccountPlayEventRange(Out<int> outCount, Out<int> startIndex, Out<int> lastIndex, nn.account.Uid user);

        [MethodId(13)]
        Result QueryApplicationPlayStatisticsForSystem(Out<int> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationPlayStatistics> outList,
            [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ApplicationId> applicationIdList);

        [MethodId(14)]
        Result QueryRecentlyPlayedApplication(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.ApplicationId> outList, nn.account.Uid user);

        [MethodId(15)]
        Result GetRecentlyPlayedApplicationUpdateEvent(Out<NativeHandle> pOutHandle);
    }
}
