﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/am_Shim.h>
#include <nn/pdm/pdm_Api.h>
#include <nn/fs/detail/fs_AccessLog.h>

namespace nn { namespace pdm {

int QueryApplicationPlayStatistics(ApplicationPlayStatistics outValues[], const ApplicationId applicationIds[], int count) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    int outCount = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        NN_DETAIL_FS_ACCESS_LOG(
            am::GetApplicationFunctions()->QueryApplicationPlayStatistics(&outCount, sf::OutArray<ApplicationPlayStatistics>(outValues, count), sf::InArray<nn::ncm::ApplicationId>(reinterpret_cast<const nn::ncm::ApplicationId*>(applicationIds), count)),
            nullptr, ""
        )
    );
    return outCount;
#else
    NN_UNUSED(outValues);
    NN_UNUSED(applicationIds);
    NN_UNUSED(count);
    return 0;
#endif
}

}}
