﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gpio/gpio.h>

namespace nn { namespace pcv { namespace driver { namespace detail {

class Sdmmc1PowerController
{
private:
    NN_DISALLOW_COPY(Sdmmc1PowerController);
    NN_DISALLOW_MOVE(Sdmmc1PowerController);

public:
    enum BusPower
    {
        BusPower_Off,
        BusPower_1_8V,
        BusPower_3_3V,
    };

private:
    void WaitMicroseconds(uint32_t us) NN_NOEXCEPT;
    Result ControlVddioSdmmc1(BusPower busPower) NN_NOEXCEPT;
    void SetSdmmc1IoMode(bool isBusPower_3_3V) NN_NOEXCEPT;
    void ControlRailSdmmc1Io(bool isPowerOn) NN_NOEXCEPT;

public:
    Sdmmc1PowerController() NN_NOEXCEPT;
    ~Sdmmc1PowerController() NN_NOEXCEPT;

    Result PowerOn(BusPower) NN_NOEXCEPT;
    Result PowerOff() NN_NOEXCEPT;
    Result LowerBusPower() NN_NOEXCEPT;
    Result IsPoweredOn(bool* pOutIsPoweredOn) NN_NOEXCEPT;

private:
    nn::gpio::GpioPadSession m_GpioPadPowSdEnSession;
    BusPower m_BusPower;
};

}}}} // namespace nn::pcv::driver::detail
