﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/pcv/pcv_PowerDomains.h>

#include <nne/max7762x/max7762x_regulator_Types.h>

namespace {

const std::pair<nn::pcv::PowerDomain, nne::max7762x::RegulatorHandle> PowerDomainRegulatorHandlePairs[] =
{
    {nn::pcv::PowerDomain_Max77620_Sd0,   nne::max7762x::REG_SD0},
    {nn::pcv::PowerDomain_Max77620_Sd1,   nne::max7762x::REG_SD1},
    {nn::pcv::PowerDomain_Max77620_Sd2,   nne::max7762x::REG_SD2},
    {nn::pcv::PowerDomain_Max77620_Sd3,   nne::max7762x::REG_SD3},

    {nn::pcv::PowerDomain_Max77620_Ldo0,  nne::max7762x::REG_LDO0},
    {nn::pcv::PowerDomain_Max77620_Ldo1,  nne::max7762x::REG_LDO1},
    {nn::pcv::PowerDomain_Max77620_Ldo2,  nne::max7762x::REG_LDO2},
    {nn::pcv::PowerDomain_Max77620_Ldo3,  nne::max7762x::REG_LDO3},
    {nn::pcv::PowerDomain_Max77620_Ldo4,  nne::max7762x::REG_LDO4},
    {nn::pcv::PowerDomain_Max77620_Ldo5,  nne::max7762x::REG_LDO5},
    {nn::pcv::PowerDomain_Max77620_Ldo6,  nne::max7762x::REG_LDO6},
    {nn::pcv::PowerDomain_Max77620_Ldo7,  nne::max7762x::REG_LDO7},
    {nn::pcv::PowerDomain_Max77620_Ldo8,  nne::max7762x::REG_LDO8},

#if !defined NN_BUILD_CONFIG_HARDWARE_JETSONTK2
    {nn::pcv::PowerDomain_Max77621_Cpu,   nne::max7762x::REG_MAX77621_CPU},
    {nn::pcv::PowerDomain_Max77621_Gpu,   nne::max7762x::REG_MAX77621_GPU},

    {nn::pcv::PowerDomain_Max77812_Cpu,   nne::max7762x::REG_MAX77812_CPU},
    {nn::pcv::PowerDomain_Max77812_Gpu,   nne::max7762x::REG_MAX77812_GPU},
    {nn::pcv::PowerDomain_Max77812_Dram,  nne::max7762x::REG_MAX77812_DRAM},
#endif
};

} // namespace
