﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pcv/pcv_Types.h>

namespace nn { namespace pcv { namespace driver { namespace detail {

//! PCV ドライバライブラリ内部の電源操作機能を初期化します。
void InitializePowerController() NN_NOEXCEPT;

//! PCV ドライバライブラリ内部の電源操作機能を終了します。
void FinalizePowerController() NN_NOEXCEPT;

//! 電源を指定した電圧で ON にします。
Result PowerOn(PowerControlTarget powerControlTarget, MicroVolt microVolt) NN_NOEXCEPT;

//! 電源を OFF にします。
Result PowerOff(PowerControlTarget powerControlTarget) NN_NOEXCEPT;

//! 電源を指定した電圧に変更します。
Result ChangeVoltage(PowerControlTarget powerControlTarget, MicroVolt microVolt) NN_NOEXCEPT;

//! 電源が ON であるかを取得します。
Result IsPoweredOn(bool* pOutIsPoweredOn, PowerControlTarget powerControlTarget) NN_NOEXCEPT;

// TODO: SIGLO-79931 のワークアラウンドです。
// Raptor の display ドライバの修正が完了され次第削除します。
bool IsSioMcuSupported() NN_NOEXCEPT;

}}}} // namespace nn::pcv::driver::detail
